/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.BlankSpan;
import io.opencensus.trace.Link;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.propagation.BinaryFormat;
import io.opencensus.trace.propagation.SpanContextParseException;
import java.lang.invoke.LambdaMetafactory;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PostCommitEventExecutor {
    private static final Logger log = LogManager.getLogger(PostCommitEventExecutor.class);
    public static final String TIMEOUT_MS_PROP = "org.nuxeo.ecm.core.event.tx.PostCommitExecutor.timeoutMs";
    public static final int DEFAULT_TIMEOUT_MS = 300;
    public static final int DEFAULT_TIMEOUT_TEST_MS = 60000;
    private Integer defaultTimeoutMs;
    public static final String DEFAULT_BULK_TIMEOUT_S = "600";
    public static final String BULK_TIMEOUT_PROP = "org.nuxeo.ecm.core.event.tx.BulkExecutor.timeout";
    private static final long KEEP_ALIVE_TIME_SECOND = 10L;
    private static final int MAX_POOL_SIZE = 100;
    protected final ExecutorService executor;

    public PostCommitEventExecutor() {
        NamedThreadFactory threadFactory = new NamedThreadFactory("Nuxeo-Event-PostCommit-");
        this.executor = new ThreadPoolExecutor(0, 100, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
    }

    protected int getDefaultTimeoutMs() {
        if (this.defaultTimeoutMs == null) {
            this.defaultTimeoutMs = Framework.getProperty((String)TIMEOUT_MS_PROP) != null ? Integer.valueOf(Integer.parseInt(Framework.getProperty((String)TIMEOUT_MS_PROP))) : (Framework.isTestModeSet() ? Integer.valueOf(60000) : Integer.valueOf(300));
        }
        return this.defaultTimeoutMs;
    }

    public void shutdown(long timeoutMillis) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
        if (!this.executor.isTerminated()) {
            this.executor.shutdownNow();
        }
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle event) {
        log.warn("Running post commit event listeners: {}. Post commit event listener execution will soon be deprecated, see NXP-27986. As explained in NXP-26911, please update your post commit event listener contributions to make the listeners asynchronous with <listener async=\"true\"...>.\n You can disable this warning by following the instructions provided in NXP-26911.", listeners);
        this.run(listeners, event, this.getDefaultTimeoutMs(), false);
    }

    public void runBulk(List<EventListenerDescriptor> listeners, EventBundle event) {
        String timeoutSeconds = Framework.getProperty((String)BULK_TIMEOUT_PROP, (String)DEFAULT_BULK_TIMEOUT_S);
        this.run(listeners, event, Long.parseLong(timeoutSeconds) * 1000L, true);
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle bundle, long timeoutMillis, boolean bulk) {
        boolean some = false;
        for (EventListenerDescriptor listener : listeners) {
            if (!listener.acceptBundle(bundle)) continue;
            some = true;
            break;
        }
        if (!some) {
            log.debug("Events postcommit execution has nothing to do");
            return;
        }
        log.debug("Events postcommit execution starting with timeout {}ms{}", new Supplier[]{() -> timeoutMillis, () -> bulk ? " in bulk mode" : ""});
        Callable<Boolean> callable = !bulk ? new EventBundleRunner(listeners, bundle) : new EventBundleBulkRunner(listeners, bundle);
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(callable);
        try {
            this.executor.execute(futureTask);
        }
        catch (RejectedExecutionException e) {
            log.error("Events postcommit execution rejected", (Throwable)e);
            return;
        }
        try {
            Boolean ok = futureTask.get(timeoutMillis, TimeUnit.MILLISECONDS);
            if (Boolean.FALSE.equals(ok)) {
                log.error("Events postcommit bulk execution aborted due to previous error");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            futureTask.cancel(true);
        }
        catch (TimeoutException e) {
            if (!bulk) {
                log.info("Events postcommit execution exceeded timeout of {}ms, leaving thread running", new Supplier[]{() -> timeoutMillis});
            } else {
                log.error("Events postcommit bulk execution exceeded timeout of {}ms, interrupting thread", new Supplier[]{() -> timeoutMillis});
                futureTask.cancel(true);
            }
        }
        catch (ExecutionException e) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = e::getCause;
            log.error("Events postcommit execution encountered unexpected exception", supplierArray);
        }
        log.debug("Events postcommit execution finished");
    }

    protected static class EventBundleBulkRunner
    implements Callable<Boolean> {
        protected final List<EventListenerDescriptor> listeners;
        protected final EventBundle bundle;
        protected final String callerThread;
        protected final byte[] traceContext;

        public EventBundleBulkRunner(List<EventListenerDescriptor> listeners, EventBundle bundle) {
            this.listeners = listeners;
            this.bundle = bundle;
            this.callerThread = Thread.currentThread().getName();
            this.traceContext = Tracing.getPropagationComponent().getBinaryFormat().toByteArray(Tracing.getTracer().getCurrentSpan().getContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Boolean call() {
            block30: {
                span = this.getTracingSpan("postcommit/EventBundleBulkRunner");
                PostCommitEventExecutor.log.debug("Events postcommit bulk execution starting in thread: {}", new Supplier[]{(Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$call$0(), ()Ljava/lang/Object;)()});
                t0 = System.currentTimeMillis();
                ok = false;
                interrupt = false;
                reconnected = null;
                tx = TransactionHelper.startTransaction();
                scope = Tracing.getTracer().withSpan(span);
                try {
                    reconnected = new ReconnectedEventBundleImpl(this.bundle, this.listeners.toString());
                    var9_9 = this.listeners.iterator();
lbl13:
                    // 2 sources

                    while (true) {
                        block31: {
                            if (!var9_9.hasNext()) break block30;
                            listener = var9_9.next();
                            filtered = listener.filterBundle(reconnected);
                            if (filtered.isEmpty()) continue;
                            v0 = new Supplier[1];
                            v0[0] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getName(), ()Ljava/lang/Object;)((EventListenerDescriptor)listener);
                            PostCommitEventExecutor.log.debug("Events postcommit bulk execution start for listener: {}", v0);
                            t1 = System.currentTimeMillis();
                            try {
                                listener.asPostCommitListener().handleEvent(filtered);
                                if (!Thread.currentThread().isInterrupted()) break block31;
                                v1 = new Supplier[1];
                                v1[0] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getName(), ()Ljava/lang/Object;)((EventListenerDescriptor)listener);
                                PostCommitEventExecutor.log.error("Events postcommit bulk execution interrupted for listener: {}, will rollback and abort bulk processing", v1);
                                interrupt = true;
                            }
                            catch (RuntimeException e) {
                                try {
                                    v3 = new Supplier[2];
                                    v3[0] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getName(), ()Ljava/lang/Object;)((EventListenerDescriptor)listener);
                                    v3[1] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$call$1(java.lang.RuntimeException ), ()Ljava/lang/Object;)((RuntimeException)e);
                                    PostCommitEventExecutor.log.error("Events postcommit bulk execution encountered exception for listener: {}", v3);
                                    span.setStatus(Status.UNKNOWN);
                                    var15_17 = Boolean.FALSE;
                                }
                                catch (Throwable var19_20) {
                                    elapsed = System.currentTimeMillis() - t1;
                                    v4 = new Supplier[2];
                                    v4[0] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getName(), ()Ljava/lang/Object;)((EventListenerDescriptor)listener);
                                    v4[1] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$call$2(long ), ()Ljava/lang/Object;)((long)elapsed);
                                    PostCommitEventExecutor.log.debug("Events postcommit bulk execution end for listener: {} in {}ms", v4);
                                    span.addAnnotation("PostCommitEventExecutor Listener " + listener.getName() + " " + elapsed + " ms");
                                    throw var19_20;
                                }
                                elapsed = System.currentTimeMillis() - t1;
                                v5 = new Supplier[2];
                                v5[0] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getName(), ()Ljava/lang/Object;)((EventListenerDescriptor)listener);
                                v5[1] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$call$2(long ), ()Ljava/lang/Object;)((long)elapsed);
                                PostCommitEventExecutor.log.debug("Events postcommit bulk execution end for listener: {} in {}ms", v5);
                                span.addAnnotation("PostCommitEventExecutor Listener " + listener.getName() + " " + elapsed + " ms");
                                if (scope != null) {
                                    scope.close();
                                }
                                try {
                                    if (reconnected != null) {
                                        reconnected.disconnect();
                                    }
                                }
                                finally {
                                    if (tx) {
                                        if (!ok) {
                                            TransactionHelper.setTransactionRollbackOnly();
                                            PostCommitEventExecutor.log.error("Rolling back transaction");
                                        }
                                        TransactionHelper.commitOrRollbackTransaction();
                                    }
                                }
                                elapsed = System.currentTimeMillis() - t0;
                                PostCommitEventExecutor.log.debug("Events postcommit bulk execution finished in {}ms", (Object)elapsed);
                                span.end();
                                return var15_17;
                            }
                        }
                        elapsed = System.currentTimeMillis() - t1;
                        v2 = new Supplier[2];
                        v2[0] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, getName(), ()Ljava/lang/Object;)((EventListenerDescriptor)listener);
                        v2[1] = (Supplier)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$call$2(long ), ()Ljava/lang/Object;)((long)elapsed);
                        PostCommitEventExecutor.log.debug("Events postcommit bulk execution end for listener: {} in {}ms", v2);
                        span.addAnnotation("PostCommitEventExecutor Listener " + listener.getName() + " " + elapsed + " ms");
                        break;
                    }
                }
                finally {
                    if (interrupt) ** break;
                    ** continue;
                }
            }
            ok = interrupt == false;
            return Boolean.TRUE;
            finally {
                try {
                    if (reconnected != null) {
                        reconnected.disconnect();
                    }
                }
                finally {
                    if (tx) {
                        if (!ok) {
                            TransactionHelper.setTransactionRollbackOnly();
                            PostCommitEventExecutor.log.error("Rolling back transaction");
                        }
                        TransactionHelper.commitOrRollbackTransaction();
                    }
                }
                elapsed = System.currentTimeMillis() - t0;
                PostCommitEventExecutor.log.debug("Events postcommit bulk execution finished in {}ms", (Object)elapsed);
                span.end();
            }
        }

        protected Span getTracingSpan(String spanName) {
            if (this.traceContext == null) {
                return BlankSpan.INSTANCE;
            }
            Tracer tracer = Tracing.getTracer();
            BinaryFormat binaryFormat = Tracing.getPropagationComponent().getBinaryFormat();
            try {
                SpanContext spanContext = binaryFormat.fromByteArray(this.traceContext);
                Span span = tracer.spanBuilderWithRemoteParent(spanName, spanContext).startSpan();
                span.addLink(Link.fromSpanContext((SpanContext)spanContext, (Link.Type)Link.Type.PARENT_LINKED_SPAN));
                HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
                map.put("tx.thread", AttributeValue.stringAttributeValue((String)Thread.currentThread().getName()));
                map.put("bundle.event_count", AttributeValue.longAttributeValue((long)this.bundle.size()));
                map.put("bundle.caller_thread", AttributeValue.stringAttributeValue((String)this.callerThread));
                span.putAttributes(map);
                return span;
            }
            catch (SpanContextParseException e) {
                log.warn("Invalid trace context: " + this.traceContext.length, (Throwable)e);
                return BlankSpan.INSTANCE;
            }
        }

        private static /* synthetic */ Object lambda$call$2(long elapsed) {
            return elapsed;
        }

        private static /* synthetic */ Object lambda$call$1(RuntimeException e) {
            return e;
        }

        private static /* synthetic */ Object lambda$call$0() {
            return Thread.currentThread().getName();
        }
    }

    protected static class EventBundleRunner
    implements Callable<Boolean> {
        protected final List<EventListenerDescriptor> listeners;
        protected final EventBundle bundle;
        protected final byte[] traceContext;
        protected String callerThread;

        public EventBundleRunner(List<EventListenerDescriptor> listeners, EventBundle bundle) {
            this.listeners = listeners;
            this.bundle = bundle;
            this.callerThread = Thread.currentThread().getName();
            this.traceContext = Tracing.getPropagationComponent().getBinaryFormat().toByteArray(Tracing.getTracer().getCurrentSpan().getContext());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public Boolean call() {
            log.debug("Events postcommit execution starting in thread: {}", new Supplier[]{() -> Thread.currentThread().getName()});
            long t0 = System.currentTimeMillis();
            EventStats stats = (EventStats)Framework.getService(EventStats.class);
            Span span = this.getTracingSpan("postcommit/EventBundleBulkRunner");
            try (Scope scope = Tracing.getTracer().withSpan(span);){
                for (EventListenerDescriptor listener : this.listeners) {
                    boolean tx;
                    ReconnectedEventBundle reconnected;
                    boolean ok;
                    long t1;
                    block35: {
                        block36: {
                            EventBundle filtered = listener.filterBundle(this.bundle);
                            if (filtered.isEmpty()) continue;
                            Supplier[] supplierArray = new Supplier[1];
                            supplierArray[0] = listener::getName;
                            log.debug("Events postcommit execution start for listener: {}", supplierArray);
                            t1 = System.currentTimeMillis();
                            ok = false;
                            reconnected = null;
                            tx = TransactionHelper.startTransaction();
                            reconnected = new ReconnectedEventBundleImpl(filtered, this.listeners.toString());
                            listener.asPostCommitListener().handleEvent(reconnected);
                            ok = true;
                            try {
                                if (reconnected != null) {
                                    reconnected.disconnect();
                                }
                                if (!tx) break block35;
                                if (ok) break block36;
                            }
                            catch (Throwable throwable) {
                                if (tx) {
                                    if (!ok) {
                                        TransactionHelper.setTransactionRollbackOnly();
                                        log.error("Rolling back transaction");
                                    }
                                    TransactionHelper.commitOrRollbackTransaction();
                                }
                                long elapsed = System.currentTimeMillis() - t1;
                                if (stats != null) {
                                    stats.logAsyncExec(listener, elapsed);
                                }
                                Supplier[] supplierArray2 = new Supplier[2];
                                supplierArray2[0] = listener::getName;
                                supplierArray2[1] = () -> elapsed;
                                log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray2);
                                span.addAnnotation("PostCommitEventExecutor#Listener " + listener.getName() + " " + elapsed + " ms");
                                throw throwable;
                            }
                            TransactionHelper.setTransactionRollbackOnly();
                            log.error("Rolling back transaction");
                        }
                        TransactionHelper.commitOrRollbackTransaction();
                    }
                    long elapsed = System.currentTimeMillis() - t1;
                    if (stats != null) {
                        stats.logAsyncExec(listener, elapsed);
                    }
                    Supplier[] supplierArray = new Supplier[2];
                    supplierArray[0] = listener::getName;
                    supplierArray[1] = () -> elapsed;
                    log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray);
                    span.addAnnotation("PostCommitEventExecutor#Listener " + listener.getName() + " " + elapsed + " ms");
                    continue;
                    catch (RuntimeException e) {
                        block37: {
                            block38: {
                                try {
                                    Supplier[] supplierArray3 = new Supplier[2];
                                    supplierArray3[0] = listener::getName;
                                    supplierArray3[1] = () -> e;
                                    log.error("Events postcommit execution encountered exception for listener: {}", supplierArray3);
                                    span.setStatus(Status.UNKNOWN);
                                }
                                catch (Throwable throwable) {
                                    block39: {
                                        block40: {
                                            try {
                                                if (reconnected != null) {
                                                    reconnected.disconnect();
                                                }
                                                if (!tx) break block39;
                                                if (ok) break block40;
                                            }
                                            catch (Throwable throwable2) {
                                                if (tx) {
                                                    if (!ok) {
                                                        TransactionHelper.setTransactionRollbackOnly();
                                                        log.error("Rolling back transaction");
                                                    }
                                                    TransactionHelper.commitOrRollbackTransaction();
                                                }
                                                long elapsed2 = System.currentTimeMillis() - t1;
                                                if (stats != null) {
                                                    stats.logAsyncExec(listener, elapsed2);
                                                }
                                                Supplier[] supplierArray4 = new Supplier[2];
                                                supplierArray4[0] = listener::getName;
                                                supplierArray4[1] = () -> elapsed;
                                                log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray4);
                                                span.addAnnotation("PostCommitEventExecutor#Listener " + listener.getName() + " " + elapsed2 + " ms");
                                                throw throwable2;
                                            }
                                            TransactionHelper.setTransactionRollbackOnly();
                                            log.error("Rolling back transaction");
                                        }
                                        TransactionHelper.commitOrRollbackTransaction();
                                    }
                                    long elapsed3 = System.currentTimeMillis() - t1;
                                    if (stats != null) {
                                        stats.logAsyncExec(listener, elapsed3);
                                    }
                                    Supplier[] supplierArray5 = new Supplier[2];
                                    supplierArray5[0] = listener::getName;
                                    supplierArray5[1] = () -> elapsed;
                                    log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray5);
                                    span.addAnnotation("PostCommitEventExecutor#Listener " + listener.getName() + " " + elapsed3 + " ms");
                                    throw throwable;
                                }
                                try {
                                    if (reconnected != null) {
                                        reconnected.disconnect();
                                    }
                                    if (!tx) break block37;
                                    if (ok) break block38;
                                }
                                catch (Throwable throwable) {
                                    if (tx) {
                                        if (!ok) {
                                            TransactionHelper.setTransactionRollbackOnly();
                                            log.error("Rolling back transaction");
                                        }
                                        TransactionHelper.commitOrRollbackTransaction();
                                    }
                                    long elapsed4 = System.currentTimeMillis() - t1;
                                    if (stats != null) {
                                        stats.logAsyncExec(listener, elapsed4);
                                    }
                                    Supplier[] supplierArray6 = new Supplier[2];
                                    supplierArray6[0] = listener::getName;
                                    supplierArray6[1] = () -> elapsed;
                                    log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray6);
                                    span.addAnnotation("PostCommitEventExecutor#Listener " + listener.getName() + " " + elapsed4 + " ms");
                                    throw throwable;
                                }
                                TransactionHelper.setTransactionRollbackOnly();
                                log.error("Rolling back transaction");
                            }
                            TransactionHelper.commitOrRollbackTransaction();
                        }
                        elapsed = System.currentTimeMillis() - t1;
                        if (stats != null) {
                            stats.logAsyncExec(listener, elapsed);
                        }
                        Supplier[] supplierArray7 = new Supplier[2];
                        supplierArray7[0] = listener::getName;
                        supplierArray7[1] = () -> elapsed;
                        log.debug("Events postcommit execution end for listener: {} in {}ms", supplierArray7);
                        span.addAnnotation("PostCommitEventExecutor#Listener " + listener.getName() + " " + elapsed + " ms");
                    }
                }
                span.setStatus(Status.OK);
            }
            finally {
                span.end();
            }
            long elapsed = System.currentTimeMillis() - t0;
            log.debug("Events postcommit execution finished in {}ms", (Object)elapsed);
            return Boolean.TRUE;
        }

        protected Span getTracingSpan(String spanName) {
            if (this.traceContext == null) {
                return BlankSpan.INSTANCE;
            }
            Tracer tracer = Tracing.getTracer();
            BinaryFormat binaryFormat = Tracing.getPropagationComponent().getBinaryFormat();
            try {
                SpanContext spanContext = binaryFormat.fromByteArray(this.traceContext);
                Span span = tracer.spanBuilderWithRemoteParent(spanName, spanContext).startSpan();
                span.addLink(Link.fromSpanContext((SpanContext)spanContext, (Link.Type)Link.Type.PARENT_LINKED_SPAN));
                HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
                map.put("tx.thread", AttributeValue.stringAttributeValue((String)Thread.currentThread().getName()));
                map.put("bundle.event_count", AttributeValue.longAttributeValue((long)this.bundle.size()));
                map.put("bundle.caller_thread", AttributeValue.stringAttributeValue((String)this.callerThread));
                span.putAttributes(map);
                return span;
            }
            catch (SpanContextParseException e) {
                log.warn("Invalid trace context: " + this.traceContext.length, (Throwable)e);
                return BlankSpan.INSTANCE;
            }
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.incrementAndGet();
            Thread thread = new Thread(this.group, r, name);
            thread.setPriority(5);
            return thread;
        }
    }
}

