/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scheduler;

import java.io.Serializable;
import java.util.Map;
import java.util.TimeZone;
import org.nuxeo.ecm.core.scheduler.EventJob;
import org.nuxeo.ecm.core.scheduler.EventJobFactory;
import org.nuxeo.ecm.core.scheduler.Schedule;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.ScheduleBuilder;
import org.quartz.TriggerBuilder;

public class DefaultEventJobFactory
implements EventJobFactory {
    @Override
    public JobBuilder buildJob(Schedule schedule, Map<String, Serializable> parameters) {
        JobDataMap map = new JobDataMap();
        if (parameters != null) {
            map.putAll(parameters);
        }
        return JobBuilder.newJob(this.getJobClass()).withIdentity(schedule.getId(), "nuxeo").usingJobData(map).usingJobData("eventId", schedule.getEventId()).usingJobData("eventCategory", schedule.getEventCategory()).usingJobData("username", schedule.getUsername());
    }

    @Override
    public TriggerBuilder<?> buildTrigger(Schedule schedule) {
        return TriggerBuilder.newTrigger().withIdentity(schedule.getId(), "nuxeo").withSchedule(this.buildSchedule(schedule));
    }

    @Override
    public ScheduleBuilder<?> buildSchedule(Schedule schedule) {
        CronScheduleBuilder builder = CronScheduleBuilder.cronSchedule((String)schedule.getCronExpression());
        if (schedule.getTimeZone() != null) {
            builder.inTimeZone(TimeZone.getTimeZone(schedule.getTimeZone()));
        }
        return builder;
    }

    protected Class<? extends EventJob> getJobClass() {
        return EventJob.class;
    }
}

