/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.audit.io;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.api.impl.blob.AbstractBlob;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

public class AuditEntryJSONWriter {
    protected static final Log log = LogFactory.getLog(AuditEntryJSONWriter.class);

    public static void asJSON(JsonGenerator jg, LogEntry logEntry) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("esAuditJson", Version.unknownVersion());
        module.addSerializer(Map.class, (JsonSerializer)new MapEntrySerializer());
        module.addSerializer(AbstractBlob.class, (JsonSerializer)new BinaryBlobEntrySerializer());
        objectMapper.registerModule((Module)module);
        jg.setCodec((ObjectCodec)objectMapper);
        jg.writeStartObject();
        jg.writeStringField("entity-type", "logEntry");
        AuditEntryJSONWriter.writeField(jg, "category", logEntry.getCategory());
        AuditEntryJSONWriter.writeField(jg, "principalName", logEntry.getPrincipalName());
        AuditEntryJSONWriter.writeField(jg, "comment", logEntry.getComment());
        AuditEntryJSONWriter.writeField(jg, "docLifeCycle", logEntry.getDocLifeCycle());
        AuditEntryJSONWriter.writeField(jg, "docPath", logEntry.getDocPath());
        AuditEntryJSONWriter.writeField(jg, "docType", logEntry.getDocType());
        AuditEntryJSONWriter.writeField(jg, "docUUID", logEntry.getDocUUID());
        AuditEntryJSONWriter.writeField(jg, "eventId", logEntry.getEventId());
        AuditEntryJSONWriter.writeField(jg, "repositoryId", logEntry.getRepositoryId());
        jg.writeStringField("eventDate", DateUtils.formatISODateTime((Date)DateUtils.nowIfNull((Date)logEntry.getEventDate())));
        jg.writeNumberField("id", logEntry.getId());
        jg.writeStringField("logDate", DateUtils.formatISODateTime((Date)DateUtils.nowIfNull((Date)logEntry.getLogDate())));
        Map extended = logEntry.getExtendedInfos();
        jg.writeObjectFieldStart("extended");
        for (String key : extended.keySet()) {
            ExtendedInfo ei = (ExtendedInfo)extended.get(key);
            if (ei != null && ei.getSerializableValue() != null) {
                Serializable value = ei.getSerializableValue();
                if (value instanceof String) {
                    String strValue = (String)((Object)value);
                    if (AuditEntryJSONWriter.isJsonContent(strValue)) {
                        jg.writeFieldName(key);
                        jg.writeRawValue(strValue);
                        continue;
                    }
                    jg.writeStringField(key, strValue);
                    continue;
                }
                try {
                    jg.writeObjectField(key, (Object)ei.getSerializableValue());
                }
                catch (JsonMappingException e) {
                    log.error((Object)"No Serializer found.", (Throwable)e);
                }
                continue;
            }
            jg.writeNullField(key);
        }
        jg.writeEndObject();
        jg.writeEndObject();
        jg.flush();
    }

    protected static boolean isJsonContent(String value) {
        if (value != null) {
            if ((value = value.trim()).startsWith("{") && value.endsWith("}")) {
                return true;
            }
            if (value.startsWith("[") && value.endsWith("]")) {
                return true;
            }
        }
        return false;
    }

    protected static void writeField(JsonGenerator jg, String name, String value) throws IOException {
        if (value == null) {
            jg.writeNullField(name);
        } else {
            jg.writeStringField(name, value);
        }
    }

    static class BinaryBlobEntrySerializer
    extends JsonSerializer<AbstractBlob> {
        BinaryBlobEntrySerializer() {
        }

        public void serialize(AbstractBlob blob, JsonGenerator jgen, SerializerProvider provider) throws JsonGenerationException, IOException {
            jgen.writeNull();
        }
    }

    static class MapEntrySerializer
    extends JsonSerializer<Map> {
        MapEntrySerializer() {
        }

        public void serialize(Map map, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            for (Object key : map.keySet()) {
                jgen.writeObjectField((String)key, map.get(key));
            }
            jgen.writeEndObject();
        }
    }
}

