/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.core;

import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.web.resources.core.ResourceDescriptor;
import org.w3c.dom.Element;

public class ResourceRegistry
extends MapRegistry {
    private static final Logger log = LogManager.getLogger(ResourceRegistry.class);

    protected <T> T doRegister(Context ctx, XAnnotatedObject xObject, Element element, String extensionId) {
        ResourceDescriptor resource = (ResourceDescriptor)super.doRegister(ctx, xObject, element, extensionId);
        if (resource != null) {
            this.computeResourceUri(resource, ctx);
        }
        return (T)resource;
    }

    protected void computeResourceUri(ResourceDescriptor resource, Context context) {
        String path;
        String uri = resource.getURI();
        if (uri == null && (path = resource.getPath()) != null) {
            URL url;
            boolean hasWildcard = false;
            if (path.endsWith("*")) {
                hasWildcard = true;
                path = path.substring(0, path.length() - 1);
            }
            if ((url = context.getResource(path)) == null) {
                log.error("Cannot resolve URL for resource '{}' with path '{}'", (Object)resource.getName(), (Object)resource.getPath());
            } else {
                Object builtUri = url.toString();
                if (hasWildcard) {
                    builtUri = (String)builtUri + "*";
                }
                resource.setURI((String)builtUri);
            }
        }
    }
}

