/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.AggregateRangeDateDefinition;
import org.nuxeo.ecm.platform.query.api.AggregateRangeDefinition;
import org.nuxeo.ecm.platform.query.api.PredicateFieldDefinition;
import org.nuxeo.ecm.platform.query.core.AggregateRangeDateDescriptor;
import org.nuxeo.ecm.platform.query.core.AggregateRangeDescriptor;
import org.nuxeo.ecm.platform.query.core.FieldDescriptor;

@XObject(value="aggregate")
public class AggregateDescriptor
implements AggregateDefinition {
    @XNode(value="field")
    protected FieldDescriptor field;
    @XNode(value="@id")
    protected String id;
    @XNode(value="@parameter")
    protected String parameter;
    @XNode(value="@type")
    protected String type;
    @XNodeMap(value="properties/property", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> properties = new HashMap<String, String>();
    @XNodeList(value="ranges/range", type=ArrayList.class, componentType=AggregateRangeDescriptor.class)
    protected List<AggregateRangeDefinition> aggregateRanges = new ArrayList<AggregateRangeDefinition>();
    private Map<String, Integer> aggregateRangeDefinitionOrderMap;
    @XNodeList(value="dateRanges/dateRange", type=ArrayList.class, componentType=AggregateRangeDateDescriptor.class)
    protected List<AggregateRangeDateDefinition> aggregateDateRanges = new ArrayList<AggregateRangeDateDefinition>();
    protected Map<String, Integer> aggregateDateRangeDefinitionOrderMap;

    public Map<String, Integer> getAggregateDateRangeDefinitionOrderMap() {
        if (this.aggregateDateRangeDefinitionOrderMap == null) {
            this.aggregateDateRangeDefinitionOrderMap = new HashMap<String, Integer>(this.getDateRanges().size());
            for (int i = 0; i < this.getDateRanges().size(); ++i) {
                this.aggregateDateRangeDefinitionOrderMap.put(this.getDateRanges().get(i).getKey(), i);
            }
        }
        return this.aggregateDateRangeDefinitionOrderMap;
    }

    public Map<String, Integer> getAggregateRangeDefinitionOrderMap() {
        if (this.aggregateRangeDefinitionOrderMap == null) {
            this.aggregateRangeDefinitionOrderMap = new HashMap<String, Integer>(this.getRanges().size());
            for (int i = 0; i < this.getRanges().size(); ++i) {
                this.aggregateRangeDefinitionOrderMap.put(this.getRanges().get(i).getKey(), i);
            }
        }
        return this.aggregateRangeDefinitionOrderMap;
    }

    public List<AggregateRangeDateDefinition> getDateRanges() {
        return Collections.unmodifiableList(this.aggregateDateRanges);
    }

    public String getDocumentField() {
        return this.parameter;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public List<AggregateRangeDefinition> getRanges() {
        return Collections.unmodifiableList(this.aggregateRanges);
    }

    public PredicateFieldDefinition getSearchField() {
        return this.field;
    }

    public String getType() {
        return this.type;
    }

    public void setDateRanges(List<AggregateRangeDateDefinition> ranges) {
        if (ranges != null) {
            this.aggregateDateRanges.addAll(ranges);
            this.aggregateDateRangeDefinitionOrderMap = null;
        }
    }

    public void setDocumentField(String parameter) {
        this.parameter = parameter;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void setRanges(List<AggregateRangeDefinition> ranges) {
        if (ranges != null) {
            this.aggregateRanges.addAll(ranges);
            this.aggregateRangeDefinitionOrderMap = null;
        }
    }

    public void setSearchField(PredicateFieldDefinition field) {
        this.field = (FieldDescriptor)field;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AggregateDescriptor clone() {
        AggregateDescriptor clone = new AggregateDescriptor();
        clone.id = this.id;
        clone.parameter = this.parameter;
        clone.type = this.type;
        if (this.field != null) {
            clone.field = this.field.clone();
        }
        if (this.properties != null) {
            clone.properties = new HashMap<String, String>(this.properties);
        }
        if (this.aggregateRanges != null) {
            clone.aggregateRanges = new ArrayList<AggregateRangeDefinition>(this.aggregateRanges.size());
            clone.aggregateRanges.addAll(this.aggregateRanges);
        }
        if (this.aggregateDateRanges != null) {
            clone.aggregateDateRanges = new ArrayList<AggregateRangeDateDefinition>(this.aggregateDateRanges.size());
            clone.aggregateDateRanges.addAll(this.aggregateDateRanges);
        }
        return clone;
    }
}

