/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class PageProviderServiceImpl
extends DefaultComponent
implements PageProviderService {
    private static final Logger log = LogManager.getLogger(PageProviderServiceImpl.class);
    private static final long serialVersionUID = 1L;
    public static final String PROVIDER_EP = "providers";
    public static final String REPLACER_EP = "replacers";
    protected Map<String, PageProviderDefinition> programmaticDefinitions;
    protected Map<String, Class<? extends PageProvider<?>>> replacerMap;

    public void activate(ComponentContext context) {
        this.programmaticDefinitions = new ConcurrentHashMap<String, PageProviderDefinition>();
    }

    public void deactivate(ComponentContext context) {
        this.programmaticDefinitions = null;
    }

    public void start(ComponentContext context) {
        this.replacerMap = new HashMap();
        this.getRegistryContributions(REPLACER_EP).forEach(desc -> {
            String className = desc.getPageProviderClassName();
            if (className == null) {
                log.error("Cannot register page provider class replacer without class name");
            } else {
                Class<?> klass;
                try {
                    klass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(String.format("Class %s not found", className));
                }
                if (!PageProvider.class.isAssignableFrom(klass)) {
                    throw new IllegalStateException(String.format("Class %s does not implement PageProvider interface", className));
                }
                for (String providerName : desc.getPageProviderNames()) {
                    this.replacerMap.put(providerName, klass);
                }
            }
        });
        this.dumpReplacerMap();
    }

    public void dumpReplacerMap() {
        if (log.isInfoEnabled()) {
            if (this.replacerMap.isEmpty()) {
                log.info("No page provider has been superseded");
                return;
            }
            StringBuilder out = new StringBuilder();
            out.append("List of page provider names that are superseded: \n");
            for (Map.Entry<String, Class<PageProvider<?>>> entry : this.replacerMap.entrySet()) {
                out.append(String.format("  - %s: %s%n", entry.getKey(), entry.getValue().getName()));
            }
            log.info(out.toString());
        }
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.replacerMap = null;
    }

    protected Optional<PageProviderDefinition> getOptionalPageProviderDefinition(String name) {
        return Optional.ofNullable(this.programmaticDefinitions.get(name)).or(() -> this.getRegistryContribution(PROVIDER_EP, name)).map(PageProviderDefinition::clone);
    }

    protected PageProviderDefinition getPageProviderDefinitionOrElseThrow(String name) {
        return this.getOptionalPageProviderDefinition(name).orElseThrow(() -> new NuxeoException(String.format("Could not resolve page provider with name '%s'", name)));
    }

    @Override
    public Set<String> getPageProviderDefinitionNames() {
        return Stream.of(this.programmaticDefinitions.keySet(), ((MapRegistry)this.getExtensionPointRegistry(PROVIDER_EP)).getContributions().keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public PageProviderDefinition getPageProviderDefinition(String name) {
        return this.getOptionalPageProviderDefinition(name).orElse(null);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<String> highlights, List<QuickFilter> quickFilters, Object ... parameters) {
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, null, properties, highlights, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Long currentOffset, Map<String, Serializable> properties, List<String> highlights, List<QuickFilter> quickFilters, Object ... parameters) {
        Long maxPageSize;
        if (desc == null) {
            return null;
        }
        PageProvider<?> pageProvider = this.newPageProviderInstance(name, desc);
        HashMap<String, Serializable> allProps = new HashMap<String, Serializable>();
        Map localProps = desc.getProperties();
        if (localProps != null) {
            allProps.putAll(localProps);
        }
        if (properties != null) {
            allProps.putAll(properties);
        }
        pageProvider.setProperties(allProps);
        pageProvider.setSortable(desc.isSortable());
        pageProvider.setParameters(parameters);
        pageProvider.setPageSizeOptions(desc.getPageSizeOptions());
        if (searchDocument != null) {
            pageProvider.setSearchDocumentModel(searchDocument);
        }
        if ((maxPageSize = desc.getMaxPageSize()) != null) {
            pageProvider.setMaxPageSize(maxPageSize.longValue());
        }
        if (sortInfos != null) {
            pageProvider.setSortInfos(sortInfos);
        }
        if (quickFilters != null) {
            pageProvider.setQuickFilters(quickFilters);
        }
        if (highlights != null) {
            pageProvider.setHighlights(highlights);
        }
        if (pageSize == null || pageSize < 0L) {
            pageProvider.setPageSize(desc.getPageSize());
        } else {
            pageProvider.setPageSize(pageSize.longValue());
        }
        if (currentPage != null && currentPage > 0L) {
            pageProvider.setCurrentPage(currentPage.longValue());
        }
        if (currentOffset != null && currentOffset >= 0L) {
            pageProvider.setCurrentPageOffset(currentOffset.longValue());
        }
        return pageProvider;
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<QuickFilter> quickFilters, Object ... parameters) {
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, null, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<String> highlights, List<QuickFilter> quickFilters, Object ... parameters) {
        return this.getPageProvider(name, (DocumentModel)null, sortInfos, pageSize, currentPage, properties, highlights, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) {
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, null, null, parameters);
    }

    protected PageProvider<?> newPageProviderInstance(String name, PageProviderDefinition desc) {
        PageProvider<?> ret;
        if (desc instanceof CoreQueryPageProviderDescriptor) {
            ret = this.newCoreQueryPageProviderInstance(name);
        } else if (desc instanceof GenericPageProviderDescriptor) {
            Class<PageProvider<?>> klass = ((GenericPageProviderDescriptor)desc).getPageProviderClass();
            ret = this.newPageProviderInstance(name, klass);
        } else {
            throw new NuxeoException(String.format("Invalid page provider definition with name '%s'", name));
        }
        ret.setName(name);
        ret.setDefinition(desc);
        return ret;
    }

    protected PageProvider<?> newCoreQueryPageProviderInstance(String name) {
        Class<? extends PageProvider<?>> klass = this.replacerMap.get(name);
        PageProvider ret = klass == null ? new PageProvider() : this.newPageProviderInstance(name, klass);
        return ret;
    }

    protected PageProvider<?> newPageProviderInstance(String name, Class<? extends PageProvider<?>> klass) {
        PageProvider<?> ret;
        if (klass == null) {
            throw new NuxeoException(String.format("Cannot find class for page provider definition with name '%s': check ERROR logs at startup", name));
        }
        try {
            ret = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException(String.format("Cannot create an instance of class %s for page provider definition with name '%s'", klass.getName(), name), (Throwable)e);
        }
        return ret;
    }

    @Override
    public PageProvider<?> getPageProvider(String name, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) {
        PageProviderDefinition desc = this.getPageProviderDefinitionOrElseThrow(name);
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, null, null, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<String> highlights, List<QuickFilter> quickFilters, Object ... parameters) {
        PageProviderDefinition desc = this.getPageProviderDefinitionOrElseThrow(name);
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, highlights, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Long currentOffset, Map<String, Serializable> properties, List<String> highlights, List<QuickFilter> quickFilters, Object ... parameters) {
        PageProviderDefinition desc = this.getPageProviderDefinitionOrElseThrow(name);
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, currentOffset, properties, highlights, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<QuickFilter> quickFilters, Object ... parameters) {
        PageProviderDefinition desc = this.getPageProviderDefinitionOrElseThrow(name);
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) {
        return this.getPageProvider(name, (DocumentModel)null, sortInfos, pageSize, currentPage, properties, parameters);
    }

    @Override
    public void registerPageProviderDefinition(PageProviderDefinition desc) {
        if (desc != null) {
            this.programmaticDefinitions.put(desc.getName(), desc);
        }
    }

    @Override
    public void unregisterPageProviderDefinition(PageProviderDefinition desc) {
        if (desc != null) {
            this.programmaticDefinitions.remove(desc.getName());
        }
    }
}

