/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.common.xmap.registry.Registry;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.DocumentTypeRegistry;
import org.nuxeo.ecm.core.schema.FacetDescriptor;
import org.nuxeo.ecm.core.schema.ProxiesDescriptor;
import org.w3c.dom.Element;

public class DocTypeRegistry
implements Registry {
    protected DocumentTypeRegistry typeRegistry = new DocumentTypeRegistry();
    protected MapRegistry facetRegistry = new MapRegistry();
    protected MapRegistry proxyRegistry = new MapRegistry();

    public void initialize() {
        this.typeRegistry.initialize();
        this.facetRegistry.initialize();
        this.proxyRegistry.initialize();
    }

    public void tag(String id) {
        this.typeRegistry.tag(id);
        this.facetRegistry.tag(id);
        this.proxyRegistry.tag(id);
    }

    public boolean isTagged(String id) {
        return this.typeRegistry.isTagged(id) || this.facetRegistry.isTagged(id) || this.proxyRegistry.isTagged(id);
    }

    public void register(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        Class klass = xObject.getKlass();
        if (DocumentTypeDescriptor.class.equals((Object)klass)) {
            this.typeRegistry.register(ctx, xObject, element, tag);
        } else if (FacetDescriptor.class.equals((Object)klass)) {
            this.facetRegistry.register(ctx, xObject, element, tag);
        } else if (ProxiesDescriptor.class.equals((Object)klass)) {
            this.proxyRegistry.register(ctx, xObject, element, tag);
        } else {
            throw new IllegalArgumentException("Unsupported class " + klass);
        }
    }

    public void unregister(String tag) {
        this.typeRegistry.unregister(tag);
        this.facetRegistry.unregister(tag);
        this.proxyRegistry.unregister(tag);
    }

    public void registerDocumentType(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        this.typeRegistry.registerDocumentType(ctx, xObject, element, tag);
    }

    public void unregisterDocumentType(String tag) {
        this.typeRegistry.unregisterDocumentType(tag);
    }

    public Map<String, DocumentTypeDescriptor> getDocumentTypes() {
        return this.typeRegistry.getContributions();
    }

    public List<ProxiesDescriptor> getProxies() {
        return this.proxyRegistry.getContributionValues();
    }

    public List<FacetDescriptor> getFacets() {
        return this.facetRegistry.getContributionValues();
    }

    public Set<String> getDisabledFacets() {
        return this.facetRegistry.getDisabledContributions();
    }
}

