/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.Context;
import org.nuxeo.common.xmap.XAnnotatedObject;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.w3c.dom.Element;

public class DocumentTypeRegistry
extends MapRegistry {
    protected MapRegistry programmaticTypes = new MapRegistry();

    public void initialize() {
        super.initialize();
        List types = this.programmaticTypes.getContributionValues();
        types.forEach(type -> {
            DocumentTypeDescriptor localType = (DocumentTypeDescriptor)this.contributions.get(type.name);
            if (localType == null) {
                return;
            }
            localType.subtypes = this.mergeSubTypes(localType.subtypes, type.subtypes);
            localType.forbiddenSubtypes = this.mergeSubTypes(localType.forbiddenSubtypes, type.forbiddenSubtypes);
        });
    }

    protected String[] mergeSubTypes(String[] orig, String[] other) {
        return (String[])Stream.concat(Arrays.stream(orig), Arrays.stream(other)).distinct().toArray(String[]::new);
    }

    protected <T> T getMergedInstance(Context ctx, XAnnotatedObject xObject, Element element, Object existing) {
        String existingPrefetch = existing != null ? ((DocumentTypeDescriptor)existing).prefetch : null;
        DocumentTypeDescriptor type = (DocumentTypeDescriptor)super.getMergedInstance(ctx, xObject, element, existing);
        if (StringUtils.isNotBlank((CharSequence)existingPrefetch)) {
            type.prefetch = String.join((CharSequence)" ", existingPrefetch, type.prefetch);
        }
        return (T)type;
    }

    public void registerDocumentType(Context ctx, XAnnotatedObject xObject, Element element, String tag) {
        this.programmaticTypes.register(ctx, xObject, element, tag);
    }

    public void unregisterDocumentType(String tag) {
        this.programmaticTypes.unregister(tag);
    }
}

