/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.FieldImpl;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

public class SchemaImpl
extends ComplexTypeImpl
implements Schema {
    private static final long serialVersionUID = 1L;
    private final Map<String, Type> types = new HashMap<String, Type>();
    public boolean isVersionWritabe;

    public SchemaImpl(String name, Namespace ns) {
        this(name, ns, false);
    }

    public SchemaImpl(String name, Namespace ns, boolean isVersionWritabe) {
        super(null, "@schemas", name, ns == null ? Namespace.DEFAULT_NS : ns);
        this.isVersionWritabe = isVersionWritabe;
    }

    public SchemaImpl(ComplexType complexType, String name, Namespace ns, boolean isVersionWritabe) {
        super(null, "@schemas", name, ns);
        this.isVersionWritabe = isVersionWritabe;
        if (complexType != null) {
            for (Field field : complexType.getFields()) {
                QName fieldname = QName.valueOf(field.getName().getLocalName(), ns.prefix);
                Type type = field.getType();
                String defaultValue = type.encode(field.getDefaultValue());
                Set<Constraint> constraint = field.getConstraints();
                FieldImpl newField = new FieldImpl(fieldname, this, type, defaultValue, 0, constraint);
                newField.setConstant(field.isConstant());
                this.addField(newField);
            }
        }
    }

    @Override
    public Type getType(String typeName) {
        return this.types.get(typeName);
    }

    @Override
    public Type[] getTypes() {
        return this.types.values().toArray(new Type[0]);
    }

    @Override
    public void registerType(Type type) {
        this.types.put(type.getName(), type);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.name + ")";
    }

    @Override
    public Schema getSchema() {
        return this;
    }

    @Override
    public boolean isVersionWritabe() {
        return this.isVersionWritabe;
    }
}

