/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.constraints;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.schema.types.constraints.AbstractConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;

public class EnumConstraint
extends AbstractConstraint {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "EnumConstraint";
    private static final String PNAME_VALUES = "Values";
    protected final Set<String> possibleValues = new HashSet<String>();

    public EnumConstraint(List<?> possibleValues) {
        for (Object possibleValue : possibleValues) {
            this.possibleValues.add(possibleValue.toString());
        }
    }

    public EnumConstraint(Object ... possibleValues) {
        for (Object possibleValue : possibleValues) {
            this.possibleValues.add(possibleValue.toString());
        }
    }

    @Override
    public boolean validate(Object object) {
        if (object == null) {
            return true;
        }
        return this.possibleValues.contains(object.toString());
    }

    @Override
    public Constraint.Description getDescription() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(PNAME_VALUES, new ArrayList<String>(this.possibleValues));
        return new Constraint.Description(NAME, params);
    }

    public Set<String> getPossibleValues() {
        return Collections.unmodifiableSet(this.possibleValues);
    }

    @Override
    public String getErrorMessage(Object invalidValue, Locale locale) {
        ArrayList<String> pathTokens = new ArrayList<String>();
        pathTokens.add("label.schema.constraint.violation");
        pathTokens.add(NAME);
        String key = StringUtils.join(pathTokens, (char)'.');
        Object[] params = new Object[]{StringUtils.join(this.getPossibleValues(), (String)", ")};
        Locale computedLocale = locale != null ? locale : Constraint.MESSAGES_DEFAULT_LANG;
        String message = EnumConstraint.getMessageString("messages", key, params, computedLocale);
        if (message != null && !message.trim().isEmpty() && !key.equals(message)) {
            return message;
        }
        return super.getErrorMessage(invalidValue, computedLocale);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.possibleValues == null ? 0 : this.possibleValues.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnumConstraint other = (EnumConstraint)obj;
        return !(this.possibleValues == null ? other.possibleValues != null : !this.possibleValues.equals(other.possibleValues));
    }
}

