/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.resolver;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolver;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolverDescriptor;
import org.nuxeo.ecm.core.schema.types.resolver.ObjectResolverService;
import org.nuxeo.runtime.model.DefaultComponent;

public class ObjectResolverServiceImpl
extends DefaultComponent
implements ObjectResolverService {
    private static final Log log = LogFactory.getLog(ObjectResolverServiceImpl.class);
    private static final String XP = "resolvers";

    @Override
    public ObjectResolver getResolver(String type, Map<String, String> parameters) {
        ObjectResolverDescriptor desc = this.getRegistryContribution(XP, type).orElse(null);
        if (desc == null) {
            return null;
        }
        Class<? extends ObjectResolver> resolverClass = desc.getResolver();
        if (resolverClass == null) {
            return null;
        }
        ObjectResolver resolver = null;
        try {
            resolver = resolverClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            log.warn((Object)String.format("Unable to instanciate %s - missing public constructor with no param", resolverClass.getCanonicalName()));
            return null;
        }
        try {
            resolver.configure(parameters);
        }
        catch (IllegalArgumentException e) {
            log.info((Object)String.format("Unable to configure %s with parameters %s", resolverClass.getCanonicalName(), parameters));
            return null;
        }
        return resolver;
    }
}

