/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.management.jvm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadDeadlocksDetector {
    protected Timer timer;
    protected final ThreadMXBean mgmt = ManagementFactory.getThreadMXBean();
    protected final Printer printer = new JVM16Printer();
    protected static final Log log = LogFactory.getLog(ThreadDeadlocksDetector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File dump(long[] lockedIds) throws IOException {
        File file = File.createTempFile("tdump-", ".log", new File("target"));
        ThreadInfo[] infos = this.mgmt.dumpAllThreads(true, true);
        try (FileOutputStream os = new FileOutputStream(file);){
            for (ThreadInfo info : infos) {
                StringBuilder sb = new StringBuilder();
                this.printer.print(sb, info);
                os.write(sb.toString().getBytes("UTF-8"));
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Locked threads: ");
            String comma = "";
            for (long lockedId : lockedIds) {
                sb.append(comma).append(lockedId);
                comma = ",";
            }
            os.write(sb.toString().getBytes("UTF-8"));
        }
        return file;
    }

    public long[] detectThreadLock() {
        long[] findMonitorDeadlockedThreads = this.mgmt.findMonitorDeadlockedThreads();
        if (findMonitorDeadlockedThreads == null) {
            return new long[0];
        }
        return findMonitorDeadlockedThreads;
    }

    public void schedule(long period, Listener listener) {
        if (this.timer != null) {
            throw new IllegalStateException("timer already scheduled");
        }
        this.timer = new Timer("Thread Deadlocks Detector");
        this.timer.schedule((TimerTask)new Task(listener), 1000L, period);
    }

    public void cancel() {
        if (this.timer == null) {
            throw new IllegalStateException("timer not scheduled");
        }
        this.timer.cancel();
        this.timer = null;
    }

    public static void killThreads(Set<Long> ids) {
        Map<Long, Thread> threads = ThreadDeadlocksDetector.getThreads();
        for (long id : ids) {
            Thread thread = threads.get(id);
            if (thread == null) continue;
            thread.stop();
        }
    }

    protected static Map<Long, Thread> getThreads() {
        ThreadGroup root = ThreadDeadlocksDetector.rootGroup(Thread.currentThread().getThreadGroup());
        int nThreads = root.activeCount();
        Thread[] threads = new Thread[2 * nThreads];
        root.enumerate(threads);
        HashMap<Long, Thread> map = new HashMap<Long, Thread>(threads.length);
        for (Thread thread : threads) {
            if (thread == null) continue;
            map.put(thread.getId(), thread);
        }
        return map;
    }

    protected static ThreadGroup rootGroup(ThreadGroup group) {
        ThreadGroup parent = group.getParent();
        if (parent == null) {
            return group;
        }
        return ThreadDeadlocksDetector.rootGroup(parent);
    }

    protected class Task
    extends TimerTask {
        protected final Listener listener;

        protected Task(Listener listener) {
            this.listener = listener;
        }

        @Override
        public void run() {
            File dumpFile;
            long[] ids = ThreadDeadlocksDetector.this.detectThreadLock();
            if (ids.length == 0) {
                return;
            }
            try {
                dumpFile = ThreadDeadlocksDetector.this.dump(ids);
            }
            catch (IOException e) {
                log.error((Object)"Cannot dump threads", (Throwable)e);
                dumpFile = new File("/dev/null");
            }
            this.listener.deadlockDetected(ids, dumpFile);
        }
    }

    public static class KillListener
    implements Listener {
        @Override
        public void deadlockDetected(long[] ids, File dumpFile) {
            log.error((Object)("Exiting, detected threads dead locks, see thread dump in " + dumpFile.getPath()));
            System.exit(1);
        }
    }

    public static interface Listener {
        public void deadlockDetected(long[] var1, File var2);
    }

    public static class JVM16Printer
    implements Printer {
        protected final ThreadMXBean mbean = ManagementFactory.getThreadMXBean();

        @Override
        public void print(StringBuilder sb, ThreadInfo thread) {
            MonitorInfo[] monitors = null;
            if (this.mbean.isObjectMonitorUsageSupported()) {
                monitors = thread.getLockedMonitors();
            }
            sb.append("\n\"").append(thread.getThreadName()).append("\" - Thread t@").append(thread.getThreadId()).append("\n").append("   java.lang.Thread.State: ").append((Object)thread.getThreadState()).append("\n");
            int index = 0;
            for (StackTraceElement st : thread.getStackTrace()) {
                LockInfo lock = thread.getLockInfo();
                String lockOwner = thread.getLockOwnerName();
                sb.append("\tat ").append(st.toString()).append("\n");
                if (index == 0) {
                    if ("java.lang.Object".equals(st.getClassName()) && "wait".equals(st.getMethodName())) {
                        if (lock != null) {
                            sb.append("\t- waiting on ");
                            this.printLock(sb, lock);
                            sb.append("\n");
                        }
                    } else if (lock != null) {
                        if (lockOwner == null) {
                            sb.append("\t- parking to wait for ");
                            this.printLock(sb, lock);
                            sb.append("\n");
                        } else {
                            sb.append("\t- waiting to lock ");
                            this.printLock(sb, lock);
                            sb.append(" owned by \"").append(lockOwner).append("\" t@").append(thread.getLockOwnerId()).append("\n");
                        }
                    }
                }
                this.printMonitors(sb, monitors, index);
                ++index;
            }
            StringBuilder jnisb = new StringBuilder();
            this.printMonitors(jnisb, monitors, -1);
            if (jnisb.length() > 0) {
                sb.append("   JNI locked monitors:\n");
                sb.append((CharSequence)jnisb);
            }
            if (this.mbean.isSynchronizerUsageSupported()) {
                sb.append("\n   Locked ownable synchronizers:");
                LockInfo[] synchronizers = thread.getLockedSynchronizers();
                if (synchronizers == null || synchronizers.length == 0) {
                    sb.append("\n\t- None\n");
                } else {
                    for (LockInfo li : synchronizers) {
                        sb.append("\n\t- locked ");
                        this.printLock(sb, li);
                        sb.append("\n");
                    }
                }
            }
        }

        @Override
        public void printMonitors(StringBuilder sb, MonitorInfo[] monitors, int index) {
            if (monitors != null) {
                for (MonitorInfo mi : monitors) {
                    if (mi.getLockedStackDepth() != index) continue;
                    sb.append("\t- locked ");
                    this.printLock(sb, mi);
                    sb.append("\n");
                }
            }
        }

        @Override
        public void printLock(StringBuilder sb, LockInfo lock) {
            String id = Integer.toHexString(lock.getIdentityHashCode());
            String className = lock.getClassName();
            sb.append("<").append(id).append("> (a ").append(className).append(")");
        }
    }

    public static interface Printer {
        public void print(StringBuilder var1, ThreadInfo var2);

        public void printMonitors(StringBuilder var1, MonitorInfo[] var2, int var3);

        public void printLock(StringBuilder var1, LockInfo var2);
    }
}

