/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics.reporter.patch;

import io.dropwizard.metrics5.Counter;
import io.dropwizard.metrics5.Gauge;
import io.dropwizard.metrics5.Histogram;
import io.dropwizard.metrics5.Meter;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricFilter;
import io.dropwizard.metrics5.MetricName;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.ScheduledReporter;
import io.dropwizard.metrics5.Timer;
import io.dropwizard.metrics5.graphite.GraphiteReporter;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.nuxeo.runtime.metrics.MetricsConfigurationDescriptor;

public class NuxeoGraphiteReporter
extends ScheduledReporter {
    protected GraphiteReporter reporter;

    public NuxeoGraphiteReporter(MetricRegistry registry, MetricFilter filter, GraphiteReporter reporter) {
        super(registry, "graphite-reporter", filter, TimeUnit.SECONDS, TimeUnit.SECONDS);
        this.reporter = reporter;
    }

    public void report(SortedMap<MetricName, Gauge<?>> gauges, SortedMap<MetricName, Counter> counters, SortedMap<MetricName, Histogram> histograms, SortedMap<MetricName, Meter> meters, SortedMap<MetricName, Timer> timers) {
        this.reporter.report(this.graphiteMetrics(gauges), this.graphiteMetrics(counters), this.graphiteMetrics(histograms), this.graphiteMetrics(meters), this.graphiteMetrics(timers));
    }

    protected <T extends Metric> SortedMap<MetricName, T> graphiteMetrics(SortedMap<MetricName, T> metrics) {
        TreeMap<MetricName, Metric> nuxeoMetrics = new TreeMap<MetricName, Metric>();
        for (Map.Entry<MetricName, T> entry : metrics.entrySet()) {
            MetricName name = entry.getKey();
            if (name.getTags().isEmpty()) {
                nuxeoMetrics.put(name, (Metric)entry.getValue());
                continue;
            }
            nuxeoMetrics.put(this.convertName(name), (Metric)entry.getValue());
        }
        return Collections.unmodifiableSortedMap(nuxeoMetrics);
    }

    protected MetricName convertName(MetricName name) {
        String graphiteName = MetricsConfigurationDescriptor.expandName(name);
        return MetricName.build((String[])new String[]{graphiteName});
    }

    public void stop() {
        this.reporter.stop();
        this.reporter = null;
        super.stop();
    }
}

