/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.listener;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.core.adapter.CollectionMember;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.runtime.api.Framework;

public class DuplicatedCollectionListener
implements EventListener {
    private static final Log log = LogFactory.getLog(DuplicatedCollectionListener.class);

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        String eventId = event.getName();
        DocumentEventContext docCxt = (DocumentEventContext)event.getContext();
        DocumentModel doc = null;
        if (eventId.equals("documentCreatedByCopy")) {
            doc = docCxt.getSourceDocument();
        } else if (eventId.equals("documentCheckedIn")) {
            DocumentRef checkedInVersionRef = (DocumentRef)ctx.getProperties().get("checkedInVersionRef");
            doc = ctx.getCoreSession().getDocument(checkedInVersionRef);
            if (!doc.isVersion()) {
                return;
            }
        } else {
            return;
        }
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        if (collectionManager.isCollection(doc)) {
            if (eventId.equals("documentCreatedByCopy")) {
                log.trace((Object)String.format("Collection %s copied", doc.getId()));
            } else if (eventId.equals("documentCheckedIn")) {
                log.trace((Object)String.format("Collection %s checked in", doc.getId()));
            }
            collectionManager.processCopiedCollection(doc);
        }
        if (collectionManager.isCollected(doc)) {
            this.processCopiedMember(doc, ctx.getCoreSession());
        }
        if (doc.isFolder() && "documentCreatedByCopy".equals(eventId)) {
            DocumentModelList deepCopiedMembers;
            DocumentModelList deepCopiedCollections;
            int offset = 0;
            CoreSession session = ctx.getCoreSession();
            do {
                deepCopiedCollections = session.query("SELECT * FROM Document WHERE ecm:mixinType = 'Collection' AND ecm:path STARTSWITH " + NXQL.escapeString((String)doc.getPathAsString()) + " ORDER BY ecm:uuid", null, 50L, (long)offset, false);
                offset += deepCopiedCollections.size();
                for (DocumentModel deepCopiedCollection : deepCopiedCollections) {
                    collectionManager.processCopiedCollection(deepCopiedCollection);
                }
            } while ((long)deepCopiedCollections.size() >= 50L);
            offset = 0;
            do {
                deepCopiedMembers = session.query("SELECT * FROM Document WHERE collectionMember:collectionIds/* IS NOT NULL AND ecm:path STARTSWITH " + NXQL.escapeString((String)doc.getPathAsString()) + " ORDER BY ecm:uuid", null, 50L, (long)offset, false);
                offset += deepCopiedMembers.size();
                for (DocumentModel deepCopiedMember : deepCopiedMembers) {
                    this.processCopiedMember(deepCopiedMember, session);
                }
            } while ((long)deepCopiedMembers.size() >= 50L);
        }
    }

    private void processCopiedMember(DocumentModel doc, CoreSession session) {
        if (!((CollectionManager)Framework.getService(CollectionManager.class)).isCollected(doc)) {
            doc.setPropertyValue("collectionMember:collectionIds", null);
        } else {
            ((CollectionMember)doc.getAdapter(CollectionMember.class)).setCollectionIds(null);
        }
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        doc = session.saveDocument(doc);
        doc.removeFacet("CollectionMember");
        session.saveDocument(doc);
    }
}

