/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class RestoredCollectionListener
implements EventListener {
    private static final Log log = LogFactory.getLog(RestoredCollectionListener.class);

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        String eventId = event.getName();
        DocumentEventContext docCxt = (DocumentEventContext)event.getContext();
        CollectionManager collectionManager = (CollectionManager)Framework.getService(CollectionManager.class);
        DocumentModel doc = null;
        DocumentModel version = null;
        if (eventId.equals("beforeRestoringDocument")) {
            doc = docCxt.getSourceDocument();
            String versionRefId = (String)docCxt.getProperties().get("RESTORED_VERSION_UUID");
            version = docCxt.getCoreSession().getDocument((DocumentRef)new IdRef(versionRefId));
            if (!collectionManager.isCollection(doc)) {
                return;
            }
        } else {
            return;
        }
        log.trace((Object)String.format("Collection %s restored", doc.getId()));
        collectionManager.processRestoredCollection(doc, version);
    }
}

