/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.platform.content.template.listener.RepositoryInitializationListener;
import org.nuxeo.ecm.platform.content.template.service.ContentFactory;
import org.nuxeo.ecm.platform.content.template.service.ContentFactoryDescriptor;
import org.nuxeo.ecm.platform.content.template.service.ContentTemplateService;
import org.nuxeo.ecm.platform.content.template.service.FactoryBindingDescriptor;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandler;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandlerDescriptor;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class ContentTemplateServiceImpl
extends DefaultComponent
implements ContentTemplateService {
    private static final Logger log = LogManager.getLogger(ContentTemplateServiceImpl.class);
    public static final String NAME = "org.nuxeo.ecm.platform.content.template.service.TemplateService";
    public static final String FACTORY_DECLARATION_EP = "factory";
    public static final String FACTORY_BINDING_EP = "factoryBinding";
    public static final String POST_CONTENT_CREATION_HANDLERS_EP = "postContentCreationHandlers";
    protected List<PostContentCreationHandler> postContentCreationHandlers;
    private RepositoryInitializationHandler initializationHandler;

    public void activate(ComponentContext context) {
        this.initializationHandler = new RepositoryInitializationListener();
        this.initializationHandler.install();
    }

    public void deactivate(ComponentContext context) {
        if (this.initializationHandler != null) {
            this.initializationHandler.uninstall();
        }
    }

    public void start(ComponentContext context) {
        this.postContentCreationHandlers = this.getOrderedHandlers();
        Set factories = ((MapRegistry)this.getExtensionPointRegistry(FACTORY_DECLARATION_EP)).getContributions().keySet();
        this.getRegistryContributions(FACTORY_BINDING_EP).stream().filter(binding -> !factories.contains(binding.getFactoryName())).forEach(binding -> {
            String msg = String.format("Factory Binding '%s' references unknown factory '%s'", binding.getName(), binding.getFactoryName());
            log.error(msg);
            this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.postContentCreationHandlers = null;
    }

    protected List<PostContentCreationHandler> getOrderedHandlers() {
        List descs = this.getRegistryContributions(POST_CONTENT_CREATION_HANDLERS_EP);
        Collections.sort(descs);
        ArrayList<PostContentCreationHandler> handlers = new ArrayList<PostContentCreationHandler>();
        for (PostContentCreationHandlerDescriptor desc : descs) {
            try {
                handlers.add(desc.getClazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                String msg = String.format("Unable to instantiate class for handler: %s (%s)", desc.getName(), e.getMessage());
                this.addRuntimeMessage(RuntimeMessage.Level.ERROR, msg);
                log.error(msg, (Throwable)e);
            }
        }
        return handlers;
    }

    @Override
    public ContentFactory getFactoryForType(String documentType) {
        return this.getFactoryInstance(documentType);
    }

    public ContentFactory getFactoryForFacet(String facet) {
        return this.getFactoryInstance(facet);
    }

    protected ContentFactory getFactoryInstance(String documentTypeOrFacet) {
        FactoryBindingDescriptor binding;
        Optional optFactory;
        if (documentTypeOrFacet == null) {
            return null;
        }
        Optional optBinding = this.getRegistryContribution(FACTORY_BINDING_EP, documentTypeOrFacet);
        if (optBinding.isPresent() && (optFactory = this.getRegistryContribution(FACTORY_DECLARATION_EP, (binding = (FactoryBindingDescriptor)optBinding.get()).getFactoryName())).isPresent()) {
            ContentFactoryDescriptor factoryDesc = (ContentFactoryDescriptor)optFactory.get();
            try {
                ContentFactory factory = factoryDesc.getClassName().getConstructor(new Class[0]).newInstance(new Object[0]);
                boolean factoryOK = factory.initFactory(binding.getOptions(), binding.getRootAcl(), binding.getTemplate());
                if (!factoryOK) {
                    log.error("Error while initializing instance of factory {}", (Object)factoryDesc.getName());
                    return null;
                }
                return factory;
            }
            catch (ReflectiveOperationException e) {
                log.error("Error while creating instance of factory {}: {}", (Object)factoryDesc.getName(), (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }

    @Override
    public void executeFactoryForType(DocumentModel createdDocument) {
        ContentFactory factory = this.getFactoryForType(createdDocument.getType());
        if (factory != null) {
            factory.createContentStructure(createdDocument);
        }
        Set facets = createdDocument.getFacets();
        for (String facet : facets) {
            factory = this.getFactoryForFacet(facet);
            if (factory == null) continue;
            factory.createContentStructure(createdDocument);
        }
    }

    @Override
    public void executePostContentCreationHandlers(CoreSession session) {
        for (PostContentCreationHandler handler : this.postContentCreationHandlers) {
            handler.execute(session);
        }
    }

    public Map<String, ContentFactoryDescriptor> getFactories() {
        Map contribs = ((MapRegistry)this.getExtensionPointRegistry(FACTORY_DECLARATION_EP)).getContributions();
        return Collections.unmodifiableMap(contribs);
    }

    public Map<String, FactoryBindingDescriptor> getFactoryBindings() {
        Map contribs = ((MapRegistry)this.getExtensionPointRegistry(FACTORY_BINDING_EP)).getContributions();
        return Collections.unmodifiableMap(contribs);
    }
}

