/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.config;

import javax.servlet.ServletException;
import org.nuxeo.ecm.webengine.jaxrs.ApplicationManager;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ResourceExtension;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletDescriptor;
import org.nuxeo.ecm.webengine.jaxrs.servlet.config.ServletRegistry;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.osgi.service.http.NamespaceException;

public class ServletRegistryComponent
extends DefaultComponent {
    public static final String XP_SERVLETS = "servlets";
    public static final String XP_FILTERS = "filters";
    public static final String XP_RESOURCES = "resources";
    public static final String XP_SUBRESOURCES = "subresources";
    protected ServletRegistry registry;

    public void start(ComponentContext context) {
        this.registry = ServletRegistry.getInstance();
        this.getRegistryContributions(XP_FILTERS).forEach(this.registry::addFilterSet);
        this.getRegistryContributions(XP_RESOURCES).forEach(this.registry::addResources);
        this.getRegistryContributions(XP_SUBRESOURCES).forEach(desc -> ApplicationManager.getInstance().getOrCreateApplication(desc.getApplication()).addExtension((ResourceExtension)desc));
        this.getRegistryContributions(XP_SERVLETS).forEach(desc -> {
            try {
                this.registry.addServlet((ServletDescriptor)desc);
            }
            catch (ServletException | NamespaceException e) {
                throw new RuntimeServiceException(e);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.getRegistryContributions(XP_SUBRESOURCES).forEach(desc -> ApplicationManager.getInstance().getOrCreateApplication(desc.getApplication()).removeExtension((ResourceExtension)desc));
        ServletRegistry.dispose();
        this.registry = null;
    }
}

