/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.core.convert.extension.ChainedConverter;
import org.nuxeo.ecm.core.convert.extension.Converter;

@XObject(value="converter")
@XRegistry
public class ConverterDescriptor {
    protected final Log log = LogFactory.getLog(ConverterDescriptor.class);
    public static final String CUSTOM_CONVERTER_TYPE = "Custom";
    public static final String CHAINED_CONVERTER_TYPE = "Chain";
    @XNode(value="@name")
    @XRegistryId
    protected String converterName;
    @XNodeList(value="sourceMimeType", type=ArrayList.class, componentType=String.class)
    protected List<String> sourceMimeTypes = new ArrayList<String>();
    @XNode(value="destinationMimeType")
    protected String destinationMimeType;
    @XNode(value="@class")
    protected Class<?> className;
    @XNode(value="@type")
    protected String converterType = "Custom";
    @XNode(value="@bypassIfSameMimeType")
    protected boolean bypassIfSameMimeType;
    @XNodeMap(value="parameters/parameter", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> parameters = new HashMap<String, String>();
    @XNodeList(value="conversionSteps/step", type=ArrayList.class, componentType=String.class)
    protected List<String> steps = new ArrayList<String>();
    @XNodeList(value="conversionSteps/subconverter", type=ArrayList.class, componentType=String.class)
    protected List<String> subConverters = new ArrayList<String>();

    public boolean isBypassIfSameMimeType() {
        return this.bypassIfSameMimeType;
    }

    public String getConverterName() {
        return this.converterName;
    }

    public List<String> getSourceMimeTypes() {
        return this.sourceMimeTypes;
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public String getDestinationMimeType() {
        return this.destinationMimeType;
    }

    public Converter getConverterInstance() throws ReflectiveOperationException {
        Converter instance;
        if (this.className == null || this.converterType.equals(CHAINED_CONVERTER_TYPE)) {
            instance = this.subConverters == null || this.subConverters.isEmpty() ? new ChainedConverter() : new ChainedConverter(this.subConverters);
            this.converterType = CHAINED_CONVERTER_TYPE;
        } else {
            instance = (Converter)this.className.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        instance.init(this);
        return instance;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getConverterType() {
        return this.converterType;
    }
}

