/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.VariableWidthHistogramAggregatorSupplier;
import org.elasticsearch.search.aggregations.support.AggregatorSupplier;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.internal.SearchContext;

public class VariableWidthHistogramAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int numBuckets;
    private final int shardSize;
    private final int initialBuffer;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register("variable_width_histogram", CoreValuesSourceType.NUMERIC, VariableWidthHistogramAggregator::new);
    }

    VariableWidthHistogramAggregatorFactory(String name, ValuesSourceConfig config, int numBuckets, int shardSize, int initialBuffer, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.numBuckets = numBuckets;
        this.shardSize = shardSize;
        this.initialBuffer = initialBuffer;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        if (cardinality != CardinalityUpperBound.ONE) {
            throw new IllegalArgumentException("[variable_width_histogram] cannot be nested inside an aggregation that collects more than a single bucket.");
        }
        AggregatorSupplier aggregatorSupplier = this.queryShardContext.getValuesSourceRegistry().getAggregator(this.config, "variable_width_histogram");
        if (!(aggregatorSupplier instanceof VariableWidthHistogramAggregatorSupplier)) {
            throw new AggregationExecutionException("Registry miss-match - expected HistogramAggregatorSupplier, found [" + aggregatorSupplier.getClass().toString() + "]");
        }
        return ((VariableWidthHistogramAggregatorSupplier)aggregatorSupplier).build(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, searchContext, parent, metadata);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new VariableWidthHistogramAggregator(this.name, this.factories, this.numBuckets, this.shardSize, this.initialBuffer, this.config, searchContext, parent, metadata);
    }
}

