/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.url.codec;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.codec.DocumentIdCodec;
import org.nuxeo.ecm.platform.url.service.AbstractDocumentViewCodec;

public class DocumentPathCodec
extends AbstractDocumentViewCodec {
    public static final int URL_MAX_LENGTH = 2000;
    public static final String PREFIX = "nxpath";
    public static final String URL_PATTERN = "/([\\w\\.]+)(?:/(.*))?@([\\w\\-\\.;=]+)/?(?:\\?(.*)?)?";
    private static final Log log = LogFactory.getLog(DocumentPathCodec.class);

    public DocumentPathCodec() {
    }

    public DocumentPathCodec(String prefix) {
    }

    @Override
    public String getPrefix() {
        if (this.prefix != null) {
            return this.prefix;
        }
        return PREFIX;
    }

    @Override
    public String getUrlFromDocumentView(DocumentView docView) {
        if ("true".equals(docView.getParameter("version")) && docView.getDocumentLocation().getIdRef() != null) {
            DocumentIdCodec idCodec = new DocumentIdCodec();
            return idCodec.getUrlFromDocumentView(docView);
        }
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (docLoc != null) {
            String uriWithParam;
            ArrayList<String> items = new ArrayList<String>();
            items.add(this.getPrefix());
            items.add(docLoc.getServerName());
            PathRef docRef = docLoc.getPathRef();
            if (docRef != null) {
                String path = docRef.toString();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.length() > 0) {
                    items.add(URIUtils.quoteURIPathComponent((String)path, (boolean)false));
                }
            }
            Object uri = String.join((CharSequence)"/", items);
            String viewId = docView.getViewId();
            if (viewId != null) {
                uri = (String)uri + "@" + viewId;
            }
            if ((uriWithParam = URIUtils.addParametersToURIQuery((String)uri, docView.getParameters())).length() > 2000) {
                if (null == docView.getDocumentLocation().getIdRef()) {
                    log.error((Object)"The DocumentLocation did not contains the RefId.");
                    return uriWithParam;
                }
                DocumentIdCodec idCodec = new DocumentIdCodec();
                return idCodec.getUrlFromDocumentView(docView);
            }
            return uriWithParam;
        }
        return null;
    }

    @Override
    public DocumentView getDocumentViewFromUrl(String url) {
        Pattern pattern = Pattern.compile(this.getPrefix() + URL_PATTERN);
        Matcher m = pattern.matcher(url);
        if (m.matches()) {
            String server = m.group(1);
            Object path = m.group(2);
            if (path != null) {
                path = "/" + URIUtils.unquoteURIPathComponent((String)path);
            }
            PathRef docRef = path != null ? new PathRef((String)path) : null;
            String viewId = m.group(3);
            int jsessionidIndex = viewId.indexOf(";jsessionid");
            if (jsessionidIndex != -1) {
                viewId = viewId.substring(0, jsessionidIndex);
            }
            String query = m.group(4);
            Map params = URIUtils.getRequestParameters((String)query);
            DocumentLocationImpl docLoc = new DocumentLocationImpl(server, (DocumentRef)docRef);
            return new DocumentViewImpl((DocumentLocation)docLoc, viewId, params);
        }
        return null;
    }
}

