/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.url.service;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.url.codec.api.DocumentViewCodec;
import org.nuxeo.ecm.platform.url.codec.descriptor.DocumentViewCodecDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentViewCodecService
extends DefaultComponent
implements DocumentViewCodecManager {
    public static final String CODECS_EXTENSION_POINT = "codecs";
    protected String defaultCodecName;
    protected DocumentViewCodec defaultCodec;
    protected Map<String, DocumentViewCodec> codecs;

    public void start(ComponentContext context) {
        this.codecs = new HashMap<String, DocumentViewCodec>();
        this.getRegistryContributions(CODECS_EXTENSION_POINT).stream().sorted(Comparator.comparing(DocumentViewCodecDescriptor::getName)).forEach(desc -> {
            DocumentViewCodec codec;
            String codecName = desc.getName();
            String className = desc.getClassName();
            if (className == null) {
                throw new IllegalArgumentException(String.format("Invalid class for codec '%s': check ERROR logs at startup", codecName));
            }
            try {
                codec = (DocumentViewCodec)DocumentViewCodecManager.class.getClassLoader().loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                String msg = String.format("Caught error when instantiating codec '%s' with class '%s' ", codecName, className);
                throw new IllegalArgumentException(msg, e);
            }
            String prefix = desc.getPrefix();
            if (prefix != null) {
                codec.setPrefix(prefix);
            }
            if (desc.getDefaultCodec() && this.defaultCodec == null) {
                this.defaultCodecName = codecName;
                this.defaultCodec = codec;
            } else {
                this.codecs.put(codecName, codec);
            }
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.defaultCodecName = null;
        this.defaultCodec = null;
        this.codecs = null;
    }

    @Override
    public String getDefaultCodecName() {
        return this.defaultCodecName;
    }

    public DocumentViewCodec getCodec() {
        return this.defaultCodec;
    }

    @Override
    public DocumentViewCodec getCodec(String codecName) {
        if (StringUtils.isBlank((CharSequence)codecName) || codecName.contentEquals(this.defaultCodecName)) {
            return this.defaultCodec;
        }
        return this.codecs.get(codecName);
    }

    @Override
    public String getUrlFromDocumentView(DocumentView docView, boolean needBaseUrl, String baseUrl) {
        String url;
        block2: {
            url = null;
            if (this.defaultCodec != null && this.defaultCodec.handleDocumentView(docView)) {
                url = this.getUrlFromDocumentView(this.defaultCodec, docView, needBaseUrl, baseUrl);
            }
            if (url != null) break block2;
            for (DocumentViewCodec codec : this.codecs.values()) {
                if (codec.handleDocumentView(docView) && (url = this.getUrlFromDocumentView(codec, docView, needBaseUrl, baseUrl)) != null) break;
            }
        }
        return url;
    }

    @Override
    public String getUrlFromDocumentView(String codecName, DocumentView docView, boolean needBaseUrl, String baseUrl) {
        DocumentViewCodec codec = this.getCodec(codecName);
        return this.getUrlFromDocumentView(codec, docView, needBaseUrl, baseUrl);
    }

    protected String getUrlFromDocumentView(DocumentViewCodec codec, DocumentView docView, boolean needBaseUrl, String baseUrl) {
        String partialUrl;
        if (codec != null && (partialUrl = codec.getUrlFromDocumentView(docView)) != null) {
            if (needBaseUrl && !StringUtils.isBlank((CharSequence)baseUrl)) {
                if (baseUrl.endsWith("/") || partialUrl.startsWith("/")) {
                    return baseUrl + partialUrl;
                }
                return baseUrl + "/" + partialUrl;
            }
            return partialUrl;
        }
        return null;
    }

    @Override
    public DocumentView getDocumentViewFromUrl(String url, boolean hasBaseUrl, String baseUrl) {
        DocumentView docView;
        block2: {
            docView = null;
            String finalUrl = this.getUrlWithoutBase(url, hasBaseUrl, baseUrl);
            if (this.defaultCodec != null && this.defaultCodec.handleUrl(finalUrl)) {
                docView = this.getDocumentViewFromUrl(this.defaultCodec, finalUrl);
            }
            if (docView != null) break block2;
            for (DocumentViewCodec codec : this.codecs.values()) {
                if (codec.handleUrl(finalUrl) && (docView = this.getDocumentViewFromUrl(codec, finalUrl)) != null) break;
            }
        }
        return docView;
    }

    @Override
    public DocumentView getDocumentViewFromUrl(String codecName, String url, boolean hasBaseUrl, String baseUrl) {
        DocumentViewCodec codec = this.getCodec(codecName);
        String finalUrl = this.getUrlWithoutBase(url, hasBaseUrl, baseUrl);
        return this.getDocumentViewFromUrl(codec, finalUrl);
    }

    protected String getUrlWithoutBase(String url, boolean hasBaseUrl, String baseUrl) {
        if (hasBaseUrl && baseUrl != null && url.startsWith(baseUrl)) {
            url = url.substring(baseUrl.length());
        }
        return url;
    }

    protected DocumentView getDocumentViewFromUrl(DocumentViewCodec codec, String finalUrl) {
        if (codec != null) {
            return codec.getDocumentViewFromUrl(finalUrl);
        }
        return null;
    }
}

