/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.nuxeo.common.xmap.registry.MapRegistry;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.VCSRepositoryFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class SQLRepositoryService
extends DefaultComponent {
    private static final String XP_REPOSITORY = "repository";

    public int getApplicationStartedOrder() {
        return 99;
    }

    public void start(ComponentContext context) {
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getService(RepositoryManager.class);
        this.getRegistryContributions(XP_REPOSITORY).forEach(desc -> {
            String name = desc.name;
            VCSRepositoryFactory repositoryFactory = new VCSRepositoryFactory(name);
            org.nuxeo.ecm.core.api.repository.Repository repository = new org.nuxeo.ecm.core.api.repository.Repository(name, desc.label, desc.isDefault(), desc.isHeadless(), (Callable)((Object)repositoryFactory), desc.pool);
            repositoryManager.addRepository(repository);
        });
    }

    public RepositoryDescriptor getRepositoryDescriptor(String name) {
        return this.getRegistryContribution(XP_REPOSITORY, name).orElse(null);
    }

    public List<String> getRepositoryNames() {
        return new ArrayList<String>(((MapRegistry)this.getExtensionPointRegistry(XP_REPOSITORY)).getContributions().keySet());
    }

    public RepositoryManagement getRepository(String repositoryName) {
        RepositoryService repositoryService = (RepositoryService)Framework.getService(RepositoryService.class);
        org.nuxeo.ecm.core.model.Repository repository = repositoryService.getRepository(repositoryName);
        if (repository == null) {
            throw new RuntimeException("Unknown repository: " + repositoryName);
        }
        if (repository instanceof Repository) {
            return (Repository)repository;
        }
        throw new RuntimeException("Unknown repository class: " + repository.getClass().getName());
    }

    public RepositoryImpl getRepositoryImpl(String repositoryName) {
        return (RepositoryImpl)this.getRepository(repositoryName);
    }

    public List<RepositoryManagement> getRepositories() {
        ArrayList<RepositoryManagement> repositories = new ArrayList<RepositoryManagement>();
        for (String repositoryName : this.getRepositoryNames()) {
            repositories.add(this.getRepository(repositoryName));
        }
        return repositories;
    }

    public FulltextConfiguration getFulltextConfiguration(String repositoryName) {
        return this.getRepositoryImpl(repositoryName).getModel().getFulltextConfiguration();
    }
}

