/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;

public class JDBCConnection {
    private static final Log log = LogFactory.getLog(JDBCConnection.class);
    private static final String APPLICATION_NAME = "ApplicationName";
    private static final String SET_CLIENT_INFO_PROP = "org.nuxeo.vcs.setClientInfo";
    private static final String SET_CLIENT_INFO_DEFAULT = "false";
    protected final Model model;
    protected final SQLInfo sqlInfo;
    protected final Dialect dialect;
    public Connection connection;
    protected boolean supportsBatchUpdates;
    public boolean countExecutes;
    public int executeCount;
    private static final AtomicLong instanceCounter = new AtomicLong(0L);
    private final long instanceNumber = instanceCounter.incrementAndGet();
    public final JDBCLogger logger = new JDBCLogger(String.valueOf(this.instanceNumber));
    protected boolean setClientInfo;

    public JDBCConnection(Model model, SQLInfo sqlInfo) {
        this.model = model;
        this.sqlInfo = sqlInfo;
        this.dialect = sqlInfo.dialect;
        this.setClientInfo = Boolean.parseBoolean(Framework.getProperty((String)SET_CLIENT_INFO_PROP, (String)SET_CLIENT_INFO_DEFAULT));
        this.connect();
    }

    public JDBCConnection() {
        this.sqlInfo = null;
        this.model = null;
        this.dialect = null;
    }

    public String getRepositoryName() {
        return this.model.getRepositoryDescriptor().name;
    }

    public Mapper.Identification getIdentification() {
        return new Mapper.Identification(null, "" + this.instanceNumber);
    }

    protected void countExecute() {
        if (this.countExecutes) {
            ++this.executeCount;
        }
    }

    public static String getDataSourceName(String repositoryName) {
        return "repository_" + repositoryName;
    }

    public void connect() {
        try {
            String dataSourceName = JDBCConnection.getDataSourceName(this.getRepositoryName());
            this.connection = ConnectionHelper.getConnection((String)dataSourceName);
            if (this.setClientInfo) {
                this.connection.setClientInfo(APPLICATION_NAME, "nuxeo m=" + this.instanceNumber);
            }
            this.supportsBatchUpdates = this.connection.getMetaData().supportsBatchUpdates();
            this.dialect.performPostOpenStatements(this.connection);
        }
        catch (SQLException cause) {
            throw new NuxeoException("Cannot connect to database: " + this.getRepositoryName(), (Throwable)cause);
        }
    }

    public void closeConnection() {
        if (this.connection != null) {
            try {
                try {
                    if (this.setClientInfo) {
                        this.connection.setClientInfo(APPLICATION_NAME, "nuxeo");
                    }
                }
                finally {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)e, (Throwable)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    protected void checkConcurrentUpdate(Throwable e) throws ConcurrentUpdateException {
        if (this.dialect.isConcurrentUpdateException(e)) {
            log.debug((Object)e, e);
            throw new ConcurrentUpdateException("Concurrent update", e);
        }
    }
}

