/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Delta;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.RowMapper;
import org.nuxeo.ecm.core.storage.sql.SelectionType;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Delete;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Insert;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Select;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Update;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.SQLStatement;
import org.nuxeo.runtime.api.Framework;

public class SQLInfo {
    private static final String ORDER_DESC = "DESC";
    private static final String ORDER_ASC = "ASC";
    public final Database database;
    public final Dialect dialect;
    public final boolean softDeleteEnabled;
    public final boolean proxiesEnabled;
    private final Model model;
    private String selectRootIdSql;
    private Column selectRootIdWhatColumn;
    private final Map<String, String> insertSqlMap;
    private final Map<String, List<Column>> insertColumnsMap;
    private final Map<String, String> deleteSqlMap;
    private final Map<SelectionType, SQLInfoSelection> selections;
    private String selectChildrenIdsAndTypesSql;
    private String selectChildrenIdsAndTypesSqlExcludeSpecialChildren;
    private String selectComplexChildrenIdsAndTypesSql;
    private String selectComplexChildrenIdsAndTypesSqlIncludeSpecialChildren;
    private List<Column> selectChildrenIdsAndTypesWhatColumns;
    private String selectDescendantsInfoSql;
    private List<Column> selectDescendantsInfoWhatColumns;
    private final Map<String, String> copySqlMap;
    private final Map<String, Column> copyIdColumnMap;
    public final Map<String, SQLInfoSelect> selectFragmentById;
    protected String createClusterNodeSql;
    protected List<Column> createClusterNodeColumns;
    protected String deleteClusterNodeSql;
    protected Column deleteClusterNodeColumn;
    protected String deleteClusterInvalsSql;
    protected Column deleteClusterInvalsColumn;
    protected List<Column> clusterInvalidationsColumns;
    protected Map<String, List<SQLStatement>> sqlStatements;
    public Map<String, Serializable> sqlStatementsProperties;
    protected List<String> getBinariesSql;
    protected List<Column> getBinariesColumns;
    private static String[] NO_ORDER_BY = new String[0];

    public SQLInfo(Model model, Dialect dialect, boolean requiresClusterSQL) {
        this.model = model;
        this.dialect = dialect;
        RepositoryDescriptor repositoryDescriptor = model.getRepositoryDescriptor();
        this.softDeleteEnabled = repositoryDescriptor.getSoftDeleteEnabled();
        this.proxiesEnabled = repositoryDescriptor.getProxiesEnabled();
        this.database = new Database(dialect);
        this.selectRootIdSql = null;
        this.selectRootIdWhatColumn = null;
        this.selectFragmentById = new HashMap<String, SQLInfoSelect>();
        this.selections = new HashMap<SelectionType, SQLInfoSelection>();
        this.selectChildrenIdsAndTypesSql = null;
        this.selectChildrenIdsAndTypesSqlExcludeSpecialChildren = null;
        this.selectChildrenIdsAndTypesWhatColumns = null;
        this.selectComplexChildrenIdsAndTypesSql = null;
        this.selectComplexChildrenIdsAndTypesSqlIncludeSpecialChildren = null;
        this.insertSqlMap = new HashMap<String, String>();
        this.insertColumnsMap = new HashMap<String, List<Column>>();
        this.deleteSqlMap = new HashMap<String, String>();
        this.copySqlMap = new HashMap<String, String>();
        this.copyIdColumnMap = new HashMap<String, Column>();
        this.getBinariesSql = new ArrayList<String>(1);
        this.getBinariesColumns = new ArrayList<Column>(1);
        this.initSQL(requiresClusterSQL);
        this.initSelections();
        try {
            this.initSQLStatements(RepositoryImpl.testProps, repositoryDescriptor.sqlInitFiles);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getSelectRootIdSql() {
        return this.selectRootIdSql;
    }

    public Column getSelectRootIdWhatColumn() {
        return this.selectRootIdWhatColumn;
    }

    public String getInsertRootIdSql() {
        return this.insertSqlMap.get("repositories");
    }

    public List<Column> getInsertRootIdColumns() {
        return this.insertColumnsMap.get("repositories");
    }

    public SQLInfoSelection getSelection(SelectionType type) {
        return this.selections.get((Object)type);
    }

    public String getSelectChildrenIdsAndTypesSql(boolean excludeSpecialChildren, boolean excludeRegularChildren) {
        if (excludeRegularChildren) {
            return excludeSpecialChildren ? this.selectComplexChildrenIdsAndTypesSql : this.selectComplexChildrenIdsAndTypesSqlIncludeSpecialChildren;
        }
        return excludeSpecialChildren ? this.selectChildrenIdsAndTypesSqlExcludeSpecialChildren : this.selectChildrenIdsAndTypesSql;
    }

    public List<Column> getSelectChildrenIdsAndTypesWhatColumns() {
        return this.selectChildrenIdsAndTypesWhatColumns;
    }

    public String getSelectDescendantsInfoSql() {
        return this.selectDescendantsInfoSql;
    }

    public List<Column> getSelectDescendantsInfoWhatColumns() {
        return this.selectDescendantsInfoWhatColumns;
    }

    public String getCreateClusterNodeSql() {
        return this.createClusterNodeSql;
    }

    public List<Column> getCreateClusterNodeColumns() {
        return this.createClusterNodeColumns;
    }

    public String getDeleteClusterNodeSql() {
        return this.deleteClusterNodeSql;
    }

    public Column getDeleteClusterNodeColumn() {
        return this.deleteClusterNodeColumn;
    }

    public String getDeleteClusterInvalsSql() {
        return this.deleteClusterInvalsSql;
    }

    public Column getDeleteClusterInvalsColumn() {
        return this.deleteClusterInvalsColumn;
    }

    public int getClusterNodeIdType() {
        return this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.CLUSTERNODE).jdbcType;
    }

    public List<Column> getClusterInvalidationsColumns() {
        return this.clusterInvalidationsColumns;
    }

    public String getInsertSql(String tableName) {
        return this.insertSqlMap.get(tableName);
    }

    public List<Column> getInsertColumns(String tableName) {
        return this.insertColumnsMap.get(tableName);
    }

    public String getIdEqualsClause(String tableName) {
        return this.database.getTable(tableName).getColumn("id").getQuotedName() + " = ?" + this.getSoftDeleteClause(tableName);
    }

    public String getSoftDeleteClause(String tableName) {
        if ("hierarchy".equals(tableName) && this.softDeleteEnabled) {
            return " AND " + this.getSoftDeleteClause();
        }
        return "";
    }

    public String getSoftDeleteClause() {
        if (this.softDeleteEnabled) {
            return this.database.getTable("hierarchy").getColumn("isdeleted").getFullQuotedName() + " IS NULL";
        }
        return null;
    }

    public SQLInfoSelect getUpdateById(String tableName, RowMapper.RowUpdate rowu) {
        Table table = this.database.getTable(tableName);
        Update update = new Update(table);
        ArrayList<Column> whatColumns = new ArrayList<Column>();
        HashSet<String> deltas = new HashSet<String>();
        for (String key : rowu.keys) {
            whatColumns.add(table.getColumn(key));
            Serializable value = rowu.row.get(key);
            if (!(value instanceof Delta) || ((Delta)value).getBase() == null) continue;
            deltas.add(key);
        }
        update.setUpdatedColumns(whatColumns, deltas);
        ArrayList<Column> whereColumns = new ArrayList<Column>(2);
        Object where = this.getIdEqualsClause(tableName);
        whereColumns.add(table.getColumn("id"));
        if (rowu.conditions != null) {
            for (Map.Entry<String, Serializable> es : rowu.conditions.entrySet()) {
                String key = es.getKey();
                boolean isNull = es.getValue() == null;
                Column column = table.getColumn(key);
                String columnName = column.getQuotedName();
                if (isNull) {
                    where = (String)where + " AND " + columnName + " IS NULL";
                    continue;
                }
                where = (String)where + " AND " + columnName + " = ?";
                whereColumns.add(column);
            }
        }
        update.setWhere((String)where);
        return new SQLInfoSelect(update.getStatement(), whatColumns, whereColumns, null);
    }

    public Update getUpdateByIdForKeys(String tableName, List<String> keys) {
        Table table = this.database.getTable(tableName);
        LinkedList<Column> columns = new LinkedList<Column>();
        for (String key : keys) {
            columns.add(table.getColumn(key));
        }
        Update update = new Update(table);
        update.setUpdatedColumns(columns);
        update.setWhere(this.getIdEqualsClause(tableName));
        return update;
    }

    public SQLInfoSelect getSelectFragmentsByIds(String tableName, int nids) {
        return this.getSelectFragmentsByIds(tableName, nids, null, null);
    }

    public SQLInfoSelect getSelectFragmentsByIds(String tableName, int nids, String[] orderBys, Set<String> skipColumns) {
        Table table = this.database.getTable(tableName);
        LinkedList<Column> whatColumns = new LinkedList<Column>();
        LinkedList<String> whats = new LinkedList<String>();
        LinkedList<Column> opaqueColumns = new LinkedList<Column>();
        for (Column column : table.getColumns()) {
            if (column.isOpaque()) {
                opaqueColumns.add(column);
                continue;
            }
            if (skipColumns != null && skipColumns.contains(column.getKey())) continue;
            whatColumns.add(column);
            whats.add(column.getQuotedName());
        }
        Column whereColumn = table.getColumn("id");
        StringBuilder sb = new StringBuilder(whereColumn.getQuotedName());
        sb.append(" IN (");
        for (int i = 0; i < nids; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append('?');
        }
        sb.append(')');
        sb.append(this.getSoftDeleteClause(tableName));
        Select select = new Select(table);
        select.setWhat(String.join((CharSequence)", ", whats));
        select.setFrom(table.getQuotedName());
        select.setWhere(sb.toString());
        if (orderBys != null) {
            LinkedList<String> orders = new LinkedList<String>();
            for (String orderBy : orderBys) {
                orders.add(table.getColumn(orderBy).getQuotedName());
            }
            select.setOrderBy(String.join((CharSequence)", ", orders));
        }
        return new SQLInfoSelect(select.getStatement(), whatColumns, Collections.singletonList(whereColumn), opaqueColumns.isEmpty() ? null : opaqueColumns);
    }

    public SQLInfoSelect getSelectAncestorsIds() {
        String sql = this.dialect.getAncestorsIdsSql();
        if (sql == null) {
            return null;
        }
        Table table = this.database.getTable("hierarchy");
        Column mainColumn = table.getColumn("id");
        return new SQLInfoSelect(sql, Collections.singletonList(mainColumn), null, null);
    }

    public SQLInfoSelect getSelectParentIds(int nids) {
        Table table = this.database.getTable("hierarchy");
        Column whatColumn = table.getColumn("parentid");
        Column whereColumn = table.getColumn("id");
        StringBuilder sb = new StringBuilder(whereColumn.getQuotedName());
        sb.append(" IN (");
        for (int i = 0; i < nids; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append('?');
        }
        sb.append(')');
        sb.append(this.getSoftDeleteClause("hierarchy"));
        Select select = new Select(table);
        select.setWhat("DISTINCT " + whatColumn.getQuotedName());
        select.setFrom(table.getQuotedName());
        select.setWhere(sb.toString());
        return new SQLInfoSelect(select.getStatement(), Collections.singletonList(whatColumn), Collections.singletonList(whereColumn), null);
    }

    public SQLInfoSelect getSelectChildrenNodeInfos(int nids) {
        Table hierTable = this.database.getTable("hierarchy");
        Column mainColumn = hierTable.getColumn("id");
        ArrayList<Column> whatColumns = new ArrayList<Column>();
        whatColumns.add(mainColumn);
        whatColumns.add(hierTable.getColumn("parentid"));
        whatColumns.add(hierTable.getColumn("primarytype"));
        whatColumns.add(hierTable.getColumn("retainuntil"));
        whatColumns.add(hierTable.getColumn("haslegalhold"));
        whatColumns.add(hierTable.getColumn("isretentionactive"));
        Table proxyTable = null;
        if (this.proxiesEnabled) {
            proxyTable = this.database.getTable("proxies");
            whatColumns.add(proxyTable.getColumn("targetid"));
            whatColumns.add(proxyTable.getColumn("versionableid"));
        }
        String selectWhats = whatColumns.stream().map(Column::getFullQuotedName).collect(Collectors.joining(", "));
        Select select = new Select(null);
        select.setWhat(selectWhats);
        Object from = hierTable.getQuotedName();
        if (this.proxiesEnabled) {
            from = (String)from + " LEFT JOIN " + proxyTable.getQuotedName() + " ON " + mainColumn.getFullQuotedName() + " = " + proxyTable.getColumn("id").getFullQuotedName();
        }
        select.setFrom((String)from);
        Column whereColumn = hierTable.getColumn("parentid");
        StringBuilder sb = new StringBuilder(whereColumn.getFullQuotedName());
        if (nids == 1) {
            sb.append(" = ?");
        } else {
            sb.append(" IN (");
            for (int i = 0; i < nids; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append('?');
            }
            sb.append(')');
        }
        sb.append(" AND ");
        sb.append(hierTable.getColumn("isproperty").getFullQuotedName());
        sb.append(" = ").append(this.dialect.toBooleanValueString(false));
        sb.append(this.getSoftDeleteClause("hierarchy"));
        select.setWhere(sb.toString());
        return new SQLInfoSelect(select.getStatement(), whatColumns, Collections.singletonList(whereColumn), null);
    }

    public String getDeleteSql(String tableName) {
        return this.deleteSqlMap.get(tableName);
    }

    public String getDeleteSql(String tableName, int n) {
        Table table = this.database.getTable(tableName);
        Delete delete = new Delete(table);
        String where = null;
        for (Column column : table.getColumns()) {
            if (!column.getKey().equals("id")) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(column.getQuotedName());
            if (n == 1) {
                sb.append(" = ?");
            } else {
                sb.append(" IN (");
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append("?");
                }
                sb.append(")");
            }
            where = sb.toString();
        }
        delete.setWhere(where);
        return delete.getStatement();
    }

    public String getSoftDeleteSql() {
        return this.dialect.getSoftDeleteSql();
    }

    public String getSoftDeleteCleanupSql() {
        return this.dialect.getSoftDeleteCleanupSql();
    }

    public SQLInfoSelect getCopyHier(boolean explicitName, boolean resetVersion) {
        Table table = this.database.getTable("hierarchy");
        Collection<Column> columns = table.getColumns();
        ArrayList<String> selectWhats = new ArrayList<String>(columns.size());
        ArrayList<Column> selectWhatColumns = new ArrayList<Column>(5);
        Insert insert = new Insert(table);
        for (Column column : columns) {
            if (column.isIdentity()) continue;
            insert.addColumn(column);
            String quotedName = column.getQuotedName();
            String key = column.getKey();
            if (key.equals("id") || key.equals("parentid") || key.equals("baseversionid") || key.equals("ischeckedin") || key.equals("isrecord") || key.equals("minorversion") && resetVersion || key.equals("majorversion") && resetVersion || key.equals("name") && explicitName) {
                selectWhats.add("?");
                selectWhatColumns.add(column);
                continue;
            }
            selectWhats.add(quotedName);
        }
        Column whereColumn = table.getColumn("id");
        Select select = new Select(null);
        select.setFrom(table.getQuotedName());
        select.setWhat(String.join((CharSequence)", ", selectWhats));
        select.setWhere(whereColumn.getQuotedName() + " = ?");
        insert.setValues(select.getStatement());
        String sql = insert.getStatement();
        return new SQLInfoSelect(sql, selectWhatColumns, Collections.singletonList(whereColumn), null);
    }

    public String getCopySql(String tableName) {
        return this.copySqlMap.get(tableName);
    }

    public Column getCopyIdColumn(String tableName) {
        return this.copyIdColumnMap.get(tableName);
    }

    protected void initSQL(boolean requiresClusterSQL) {
        if (requiresClusterSQL) {
            if (!this.dialect.isClusteringSupported()) {
                throw new NuxeoException("Clustering not supported for " + this.dialect.getClass().getSimpleName());
            }
            this.initClusterSQL();
        }
        this.initHierarchySQL();
        this.initRepositorySQL();
        if (this.dialect.supportsAncestorsTable()) {
            this.initAncestorsSQL();
        }
        for (String tableName : this.model.getFragmentNames()) {
            if (tableName.equals("hierarchy")) continue;
            this.initFragmentSQL(tableName);
        }
        Table hierTable = this.database.getTable("hierarchy");
        Table versionTable = this.database.getTable("versions");
        hierTable.addIndex("isversion");
        versionTable.addIndex("versionableid");
        if (this.proxiesEnabled) {
            Table proxyTable = this.database.getTable("proxies");
            proxyTable.addIndex("versionableid");
            proxyTable.addIndex("targetid");
        }
        this.initSelectDescendantsSQL();
        if (!this.model.getRepositoryDescriptor().getFulltextDescriptor().getFulltextSearchDisabled()) {
            Table table = this.database.getTable("fulltext");
            FulltextConfiguration fulltextConfiguration = this.model.getFulltextConfiguration();
            if (fulltextConfiguration.indexNames.size() > 1 && !this.dialect.supportsMultipleFulltextIndexes()) {
                String msg = String.format("SQL database supports only one fulltext index, but %d are configured: %s", fulltextConfiguration.indexNames.size(), fulltextConfiguration.indexNames);
                throw new NuxeoException(msg);
            }
            for (String indexName : fulltextConfiguration.indexNames) {
                String suffix = this.model.getFulltextIndexSuffix(indexName);
                int ftic = this.dialect.getFulltextIndexedColumns();
                if (ftic == 1) {
                    table.addIndex(indexName, Table.IndexType.FULLTEXT, "fulltext" + suffix);
                    continue;
                }
                if (ftic != 2) continue;
                table.addIndex(indexName, Table.IndexType.FULLTEXT, "simpletext" + suffix, "binarytext" + suffix);
            }
        }
        for (Map.Entry<String, List<String>> e : this.model.getBinaryPropertyInfos().entrySet()) {
            String tableName = e.getKey();
            Table table = this.database.getTable(tableName);
            for (String key : e.getValue()) {
                Select select = new Select(table);
                Column col = table.getColumn(key);
                select.setWhat("DISTINCT " + col.getQuotedName());
                select.setFrom(table.getQuotedName());
                this.getBinariesSql.add(select.getStatement());
                Column resCol = new Column(table, null, ColumnType.STRING, null);
                this.getBinariesColumns.add(resCol);
            }
        }
    }

    protected void initClusterSQL() {
        TableMaker maker = new TableMaker("cluster_nodes");
        maker.newColumn("nodeid", ColumnType.CLUSTERNODE);
        maker.newColumn("created", ColumnType.TIMESTAMP);
        maker.table.addIndex(null, Table.IndexType.UNIQUE, "nodeid");
        maker.postProcessClusterNodes();
        maker = new TableMaker("cluster_invals");
        maker.newColumn("nodeid", ColumnType.CLUSTERNODE);
        maker.newColumn("id", ColumnType.NODEVAL);
        maker.newColumn("fragments", ColumnType.CLUSTERFRAGS);
        maker.newColumn("kind", ColumnType.TINYINT);
        maker.table.addIndex("nodeid");
        maker.postProcessClusterInvalidations();
    }

    protected void initRepositorySQL() {
        TableMaker maker = new TableMaker("repositories");
        maker.newColumn("id", ColumnType.NODEIDFK);
        maker.newColumn("name", ColumnType.SYSNAME);
        maker.table.addIndex(null, Table.IndexType.UNIQUE, "name");
        maker.postProcessRepository();
    }

    protected void initHierarchySQL() {
        TableMaker maker = new TableMaker("hierarchy");
        maker.newColumn("id", ColumnType.NODEID);
        maker.newColumn("parentid", ColumnType.NODEIDFKNULL);
        maker.newColumn("pos", ColumnType.INTEGER);
        maker.newColumn("name", ColumnType.STRING);
        maker.newColumn("isproperty", ColumnType.BOOLEAN);
        maker.newFragmentFields();
        maker.postProcess();
        maker.postProcessHierarchy();
        maker.table.addIndex("parentid");
        maker.table.addIndex("parentid", "name");
        maker.table.addIndex("primarytype");
        maker.table.addIndex("retainuntil");
        if (this.model.getRepositoryDescriptor().getSoftDeleteEnabled()) {
            maker.table.addIndex("isdeleted");
        }
    }

    protected void initSelectDescendantsSQL() {
        Table hierTable = this.database.getTable("hierarchy");
        Table proxyTable = null;
        if (this.proxiesEnabled) {
            proxyTable = this.database.getTable("proxies");
        }
        Column mainColumn = hierTable.getColumn("id");
        ArrayList<Column> whatCols = new ArrayList<Column>(Arrays.asList(mainColumn, hierTable.getColumn("parentid"), hierTable.getColumn("primarytype"), hierTable.getColumn("isproperty"), hierTable.getColumn("retainuntil"), hierTable.getColumn("haslegalhold"), hierTable.getColumn("isretentionactive")));
        if (this.proxiesEnabled) {
            whatCols.add(proxyTable.getColumn("versionableid"));
            whatCols.add(proxyTable.getColumn("targetid"));
        }
        String whats = whatCols.stream().map(Column::getFullQuotedName).collect(Collectors.joining(", "));
        Select select = new Select(null);
        select.setWhat(whats);
        Object from = hierTable.getQuotedName();
        if (this.proxiesEnabled) {
            from = (String)from + " LEFT JOIN " + proxyTable.getQuotedName() + " ON " + mainColumn.getFullQuotedName() + " = " + proxyTable.getColumn("id").getFullQuotedName();
        }
        select.setFrom((String)from);
        Object where = this.dialect.getInTreeSql(mainColumn.getFullQuotedName(), null);
        where = (String)where + this.getSoftDeleteClause("hierarchy");
        select.setWhere((String)where);
        this.selectDescendantsInfoSql = select.getStatement();
        this.selectDescendantsInfoWhatColumns = whatCols;
    }

    protected void initAncestorsSQL() {
        TableMaker maker = new TableMaker("ancestors");
        maker.newColumn("id", ColumnType.NODEIDFKMUL);
        maker.newColumn("ancestors", ColumnType.NODEARRAY);
    }

    protected void initFragmentSQL(String tableName) {
        TableMaker maker = new TableMaker(tableName);
        ColumnType type = tableName.equals("hierarchy") ? ColumnType.NODEID : (tableName.equals("locks") ? ColumnType.NODEIDPK : (this.model.isCollectionFragment(tableName) ? ColumnType.NODEIDFKMUL : ColumnType.NODEIDFK));
        maker.newColumn("id", type);
        maker.newFragmentFields();
        maker.postProcess();
        if ("collection:documentIds".equals(tableName)) {
            maker.table.addIndex("item");
        }
    }

    protected void initSelections() {
        for (SelectionType selType : SelectionType.values()) {
            if (!this.proxiesEnabled && selType.tableName.equals("proxies")) continue;
            this.selections.put(selType, new SQLInfoSelection(selType));
        }
    }

    public SQLInfoSelect makeSelect(Table table, String[] orderBys, String ... freeColumns) {
        return this.makeSelect(table, (String)null, (List<String>)null, orderBys, freeColumns);
    }

    public SQLInfoSelect makeSelect(Table table, String from, List<String> clauses, String[] orderBys, String ... freeColumns) {
        boolean fullQuotedName = from != null;
        List<String> freeColumnsList = Arrays.asList(freeColumns);
        LinkedList<Column> whatColumns = new LinkedList<Column>();
        LinkedList<Column> whereColumns = new LinkedList<Column>();
        LinkedList<Column> opaqueColumns = new LinkedList<Column>();
        LinkedList<String> whats = new LinkedList<String>();
        LinkedList<Object> wheres = new LinkedList<Object>();
        for (Column column : table.getColumns()) {
            String qname;
            String string = qname = fullQuotedName ? column.getFullQuotedName() : column.getQuotedName();
            if (freeColumnsList.contains(column.getKey())) {
                whereColumns.add(column);
                wheres.add(qname + " = ?");
                continue;
            }
            if (column.isOpaque()) {
                opaqueColumns.add(column);
                continue;
            }
            whatColumns.add(column);
            whats.add(qname);
        }
        if (whats.isEmpty()) {
            whats.add(table.getColumn("id").getQuotedName());
        }
        if (clauses != null) {
            wheres.addAll(clauses);
        }
        Select select = new Select(table);
        select.setWhat(String.join((CharSequence)", ", whats));
        if (from == null) {
            from = table.getQuotedName();
        }
        select.setFrom(from);
        String where = String.join((CharSequence)" AND ", wheres) + this.getSoftDeleteClause(table.getKey());
        select.setWhere(where);
        LinkedList<CallSite> orders = new LinkedList<CallSite>();
        for (int i = 0; i < orderBys.length; ++i) {
            String name = orderBys[i++];
            String ascdesc = orderBys[i].equals(ORDER_DESC) ? " DESC" : "";
            Column col = table.getColumn(name);
            String qcol = fullQuotedName ? col.getFullQuotedName() : col.getQuotedName();
            orders.add((CallSite)((Object)(qcol + ascdesc)));
        }
        select.setOrderBy(String.join((CharSequence)", ", orders));
        return new SQLInfoSelect(select.getStatement(), whatColumns, whereColumns, opaqueColumns.isEmpty() ? null : opaqueColumns);
    }

    public void initSQLStatements(Map<String, Serializable> testProps, List<String> sqlInitFiles) throws IOException {
        this.sqlStatements = new HashMap<String, List<SQLStatement>>();
        SQLStatement.read(this.dialect.getSQLStatementsFilename(), this.sqlStatements);
        if (sqlInitFiles != null) {
            for (String filename : sqlInitFiles) {
                SQLStatement.read(filename, this.sqlStatements);
            }
        }
        if (!testProps.isEmpty()) {
            SQLStatement.read(this.dialect.getTestSQLStatementsFilename(), this.sqlStatements, true);
        }
        this.sqlStatementsProperties = this.dialect.getSQLStatementsProperties(this.model, this.database);
        if (!testProps.isEmpty()) {
            this.sqlStatementsProperties.putAll(testProps);
        }
    }

    public void executeSQLStatements(String category, String ddlMode, Connection connection, JDBCLogger logger, SQLStatement.ListCollector ddlCollector) throws SQLException {
        List<SQLStatement> statements = this.sqlStatements.get(category);
        if (statements != null) {
            SQLStatement.execute(statements, ddlMode, this.sqlStatementsProperties, this.dialect, connection, logger, ddlCollector);
        }
    }

    public int getMaximumArgsForIn() {
        return this.dialect.getMaximumArgsForIn();
    }

    public static class ColumnMapMaker
    implements MapMaker {
        public final List<Column> columns;
        public final List<String> keys;

        public ColumnMapMaker(List<Column> columns) {
            this.columns = columns;
            this.keys = columns.stream().map(Column::getKey).collect(Collectors.toList());
        }

        public ColumnMapMaker(List<Column> columns, List<String> keys) {
            this.columns = columns;
            this.keys = keys;
        }

        @Override
        public Map<String, Serializable> makeMap(ResultSet rs) throws SQLException {
            HashMap<String, Serializable> map = new HashMap<String, Serializable>();
            int i = 1;
            for (Column column : this.columns) {
                String key = this.keys.get(i - 1);
                Object value = column.getFromResultSet(rs, i++);
                if ("ecm:uuid".equals(key) || "ecm:parentId".equals(key)) {
                    value = String.valueOf(value);
                }
                map.put(key, (Serializable)value);
            }
            return map;
        }
    }

    public static interface MapMaker {
        public Map<String, Serializable> makeMap(ResultSet var1) throws SQLException;
    }

    public class SQLInfoSelection {
        public final SelectionType type;
        public final SQLInfoSelect selectAll;
        public final SQLInfoSelect selectFiltered;

        public SQLInfoSelection(SelectionType selType) {
            SQLInfoSelect selectFiltered;
            SQLInfoSelect selectAll;
            List<String> clauses;
            this.type = selType;
            Table table = SQLInfo.this.database.getTable(selType.tableName);
            Object from = table.getQuotedName();
            if (selType.tableName.equals("hierarchy")) {
                clauses = null;
            } else {
                Table hierTable = SQLInfo.this.database.getTable("hierarchy");
                Join join = new Join(1, hierTable.getQuotedName(), null, null, hierTable.getColumn("id"), table.getColumn("id"));
                from = (String)from + join.toSql(SQLInfo.this.dialect);
                String clause = SQLInfo.this.getSoftDeleteClause();
                List<String> list = clauses = clause == null ? null : Collections.singletonList(clause);
            }
            if (selType.criterionKey == null) {
                selectAll = SQLInfo.this.makeSelect(table, (String)from, clauses, NO_ORDER_BY, selType.selKey);
                selectFiltered = SQLInfo.this.makeSelect(table, (String)from, clauses, NO_ORDER_BY, selType.selKey, selType.filterKey);
            } else {
                selectAll = SQLInfo.this.makeSelect(table, (String)from, clauses, NO_ORDER_BY, selType.selKey, selType.criterionKey);
                selectFiltered = SQLInfo.this.makeSelect(table, (String)from, clauses, NO_ORDER_BY, selType.selKey, selType.filterKey, selType.criterionKey);
            }
            this.selectAll = selectAll;
            this.selectFiltered = selectFiltered;
        }

        public SQLInfoSelect getSelectSelectionIds(int nids) {
            Table table = SQLInfo.this.database.getTable(this.type.tableName);
            Object from = table.getQuotedName();
            Table hierTable = SQLInfo.this.database.getTable("hierarchy");
            Join join = new Join(1, hierTable.getQuotedName(), null, null, hierTable.getColumn("id"), table.getColumn("id"));
            from = (String)from + join.toSql(SQLInfo.this.dialect);
            Column whatColumn = table.getColumn("id");
            Column whereColumn = table.getColumn(this.type.selKey);
            StringBuilder sb = new StringBuilder(whereColumn.getQuotedName());
            sb.append(" IN (");
            for (int i = 0; i < nids; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append('?');
            }
            sb.append(')');
            sb.append(SQLInfo.this.getSoftDeleteClause("hierarchy"));
            Select select = new Select(table);
            select.setWhat(whatColumn.getFullQuotedName());
            select.setFrom((String)from);
            select.setWhere(sb.toString());
            return new SQLInfoSelect(select.getStatement(), Collections.singletonList(whatColumn), Collections.singletonList(whereColumn), null);
        }
    }

    public static class SQLInfoSelect {
        public final String sql;
        public final List<Column> whatColumns;
        public final MapMaker mapMaker;
        public final List<Column> whereColumns;
        public final List<Column> opaqueColumns;

        public SQLInfoSelect(String sql, List<Column> whatColumns, List<Column> whereColumns, List<Column> opaqueColumns) {
            this(sql, whatColumns, null, whereColumns, opaqueColumns);
        }

        public SQLInfoSelect(String sql, MapMaker mapMaker) {
            this(sql, null, mapMaker, null, null);
        }

        public SQLInfoSelect(String sql, List<Column> whatColumns, MapMaker mapMaker, List<Column> whereColumns, List<Column> opaqueColumns) {
            this.sql = sql;
            this.whatColumns = whatColumns;
            this.mapMaker = mapMaker;
            this.whereColumns = whereColumns == null ? null : new ArrayList<Column>(whereColumns);
            this.opaqueColumns = opaqueColumns == null ? null : new ArrayList<Column>(opaqueColumns);
        }
    }

    protected class TableMaker {
        private final String tableName;
        private final Table table;
        private final String orderBy;

        protected TableMaker(String tableName) {
            this.tableName = tableName;
            this.table = SQLInfo.this.database.addTable(tableName);
            this.orderBy = SQLInfo.this.model.getCollectionOrderBy(tableName);
        }

        protected void newFragmentFields() {
            Map<String, ColumnType> keysType = SQLInfo.this.model.getFragmentKeysType(this.tableName);
            for (Map.Entry<String, ColumnType> entry : keysType.entrySet()) {
                this.newColumn(entry.getKey(), entry.getValue());
            }
        }

        protected Column newColumn(String columnName, ColumnType type) {
            Column column = this.table.addColumn(columnName, type, columnName, SQLInfo.this.model);
            if (type == ColumnType.NODEID) {
                column.setNullable(false);
                column.setPrimary(true);
            }
            if (type == ColumnType.NODEIDFK || type == ColumnType.NODEIDPK) {
                column.setNullable(false);
                column.setPrimary(true);
            }
            if (type == ColumnType.NODEIDFKMUL) {
                column.setNullable(false);
                this.table.addIndex(columnName);
            }
            if (type == ColumnType.NODEIDFK || type == ColumnType.NODEIDFKNP || type == ColumnType.NODEIDFKNULL || type == ColumnType.NODEIDFKMUL) {
                column.setReferences(SQLInfo.this.database.getTable("hierarchy"), "id");
            }
            return column;
        }

        protected void postProcessClusterNodes() {
            Column column2;
            Collection<Column> columns = this.table.getColumns();
            Insert insert = new Insert(this.table);
            for (Column column2 : columns) {
                insert.addColumn(column2);
            }
            SQLInfo.this.createClusterNodeSql = insert.getStatement();
            SQLInfo.this.createClusterNodeColumns = new ArrayList<Column>(columns);
            Delete delete = new Delete(this.table);
            column2 = this.table.getColumn("nodeid");
            delete.setWhere(column2.getQuotedName() + " = ?");
            SQLInfo.this.deleteClusterNodeSql = delete.getStatement();
            SQLInfo.this.deleteClusterNodeColumn = column2;
        }

        protected void postProcessClusterInvalidations() {
            SQLInfo.this.clusterInvalidationsColumns = Arrays.asList(this.table.getColumn("nodeid"), this.table.getColumn("id"), this.table.getColumn("fragments"), this.table.getColumn("kind"));
            Delete delete = new Delete(this.table);
            Column column = this.table.getColumn("nodeid");
            delete.setWhere(column.getQuotedName() + " = ?");
            SQLInfo.this.deleteClusterInvalsSql = delete.getStatement();
            SQLInfo.this.deleteClusterInvalsColumn = column;
        }

        protected void postProcessRepository() {
            this.postProcessRootIdSelect();
            this.postProcessInsert();
        }

        protected void postProcessRootIdSelect() {
            String what = null;
            String where = null;
            for (Column column : this.table.getColumns()) {
                String key = column.getKey();
                String qname = column.getQuotedName();
                if (key.equals("id")) {
                    what = qname;
                    SQLInfo.this.selectRootIdWhatColumn = column;
                    continue;
                }
                if (key.equals("name")) {
                    where = qname + " = ?";
                    continue;
                }
                throw new RuntimeException(column.toString());
            }
            Select select = new Select(this.table);
            select.setWhat(what);
            select.setFrom(this.table.getQuotedName());
            select.setWhere(where);
            SQLInfo.this.selectRootIdSql = select.getStatement();
        }

        protected void postProcess() {
            this.postProcessSelectById();
            this.postProcessInsert();
            this.postProcessDelete();
            this.postProcessCopy();
        }

        protected void postProcessHierarchy() {
            this.postProcessSelectChildrenIdsAndTypes();
        }

        protected void postProcessSelectById() {
            String[] stringArray;
            if (this.orderBy == null) {
                stringArray = NO_ORDER_BY;
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = this.orderBy;
                stringArray = stringArray2;
                stringArray2[1] = SQLInfo.ORDER_ASC;
            }
            String[] orderBys = stringArray;
            SQLInfoSelect select = SQLInfo.this.makeSelect(this.table, orderBys, "id");
            SQLInfo.this.selectFragmentById.put(this.tableName, select);
        }

        protected void postProcessSelectChildrenIdsAndTypes() {
            ArrayList<Column> whatColumns = new ArrayList<Column>(2);
            ArrayList<String> whats = new ArrayList<String>(2);
            Column column = this.table.getColumn("id");
            whatColumns.add(column);
            whats.add(column.getQuotedName());
            column = this.table.getColumn("primarytype");
            whatColumns.add(column);
            whats.add(column.getQuotedName());
            column = this.table.getColumn("mixintypes");
            whatColumns.add(column);
            whats.add(column.getQuotedName());
            column = this.table.getColumn("isrecord");
            whatColumns.add(column);
            whats.add(column.getQuotedName());
            Select select = new Select(this.table);
            select.setWhat(String.join((CharSequence)", ", whats));
            select.setFrom(this.table.getQuotedName());
            String where = this.table.getColumn("parentid").getQuotedName() + " = ?" + SQLInfo.this.getSoftDeleteClause(this.tableName);
            select.setWhere(where);
            SQLInfo.this.selectChildrenIdsAndTypesSql = select.getStatement();
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            String excludedTypes = String.join((CharSequence)"', '", schemaManager.getSpecialDocumentTypes());
            if (!excludedTypes.isEmpty()) {
                String excludeSpecialChildrenClause = " AND " + this.table.getColumn("primarytype").getQuotedName() + " NOT IN ('" + excludedTypes + "')";
                select.setWhere(where + excludeSpecialChildrenClause);
            }
            SQLInfo.this.selectChildrenIdsAndTypesSqlExcludeSpecialChildren = select.getStatement();
            SQLInfo.this.selectChildrenIdsAndTypesWhatColumns = whatColumns;
            String isComplexClause = this.table.getColumn("isproperty").getQuotedName() + " = " + SQLInfo.this.dialect.toBooleanValueString(true);
            String whereAnd = where + " AND " + isComplexClause;
            select.setWhere(whereAnd);
            SQLInfo.this.selectComplexChildrenIdsAndTypesSql = select.getStatement();
            if (!excludedTypes.isEmpty()) {
                String whereAndOr = where + " AND ( " + isComplexClause + " OR " + this.table.getColumn("primarytype").getQuotedName() + " IN ('" + excludedTypes + "') )";
                select.setWhere(whereAndOr);
            }
            SQLInfo.this.selectComplexChildrenIdsAndTypesSqlIncludeSpecialChildren = select.getStatement();
        }

        protected void postProcessInsert() {
            Collection<Column> columns = this.table.getColumns();
            ArrayList<Column> insertColumns = new ArrayList<Column>(columns.size());
            Insert insert = new Insert(this.table);
            for (Column column : columns) {
                if (column.isIdentity()) continue;
                insertColumns.add(column);
                insert.addColumn(column);
            }
            SQLInfo.this.insertSqlMap.put(this.tableName, insert.getStatement());
            SQLInfo.this.insertColumnsMap.put(this.tableName, insertColumns);
        }

        protected void postProcessDelete() {
            Delete delete = new Delete(this.table);
            String wheres = this.table.getColumns().stream().filter(col -> "id".equals(col.getKey())).map(col -> col.getQuotedName() + " = ?").collect(Collectors.joining(" AND "));
            delete.setWhere(wheres);
            SQLInfo.this.deleteSqlMap.put(this.tableName, delete.getStatement());
        }

        protected void postProcessCopy() {
            Collection<Column> columns = this.table.getColumns();
            ArrayList<String> selectWhats = new ArrayList<String>(columns.size());
            Column copyIdColumn = this.table.getColumn("id");
            Insert insert = new Insert(this.table);
            for (Column column : columns) {
                if (column.isIdentity()) continue;
                insert.addColumn(column);
                if (column == copyIdColumn) {
                    selectWhats.add("?");
                    continue;
                }
                selectWhats.add(column.getQuotedName());
            }
            Select select = new Select(this.table);
            select.setWhat(String.join((CharSequence)", ", selectWhats));
            select.setFrom(this.table.getQuotedName());
            select.setWhere(copyIdColumn.getQuotedName() + " = ?");
            insert.setValues(select.getStatement());
            SQLInfo.this.copySqlMap.put(this.tableName, insert.getStatement());
            SQLInfo.this.copyIdColumnMap.put(this.tableName, copyIdColumn);
        }
    }
}

