/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.db;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;

public class Join
implements Serializable,
Comparable<Join> {
    private static final long serialVersionUID = 1L;
    public static final int INNER = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int IMPLICIT = 4;
    public final int kind;
    public final String table;
    public final String tableAlias;
    public final String tableParam;
    public Column column1;
    public Column column2;
    public String on1;
    public String on2;
    public final List<String> whereClauses = new LinkedList<String>();
    public final List<Serializable> whereParams = new LinkedList<Serializable>();

    private Join(int kind, String table, String tableAlias, String tableParam) {
        this.kind = kind;
        this.table = table;
        this.tableAlias = tableAlias;
        this.tableParam = tableParam;
    }

    public Join(int kind, String table, String tableAlias, String tableParam, Column column1, Column column2) {
        this(kind, table, tableAlias, tableParam);
        this.column1 = column1;
        this.column2 = column2;
    }

    public Join(int kind, String table, String tableAlias, String tableParam, String on1, String on2) {
        this(kind, table, tableAlias, tableParam);
        this.on1 = on1;
        this.on2 = on2;
    }

    public void addWhereClause(String whereClause, Serializable whereParam) {
        this.whereClauses.add(whereClause);
        this.whereParams.add(whereParam);
    }

    @Override
    public int compareTo(Join other) {
        if (this.kind == 4 && other.kind == 4) {
            return 0;
        }
        if (this.kind == 4) {
            return 1;
        }
        if (other.kind == 4) {
            return -1;
        }
        return 0;
    }

    public String getTable(Dialect dialect) {
        if (this.tableAlias == null) {
            return this.table;
        }
        return this.table + " " + dialect.openQuote() + this.tableAlias + dialect.closeQuote();
    }

    public String getClause(Dialect dialect) {
        if (this.on1 == null && this.on2 == null) {
            this.on1 = this.column1.getFullQuotedName();
            this.on2 = this.column2.getFullQuotedName();
            boolean isid1 = this.column1.getType().isId();
            boolean isid2 = this.column2.getType().isId();
            if (dialect != null && isid1 != isid2) {
                if (isid1) {
                    this.on1 = dialect.castIdToVarchar(this.on1);
                } else {
                    this.on2 = dialect.castIdToVarchar(this.on2);
                }
            }
        }
        return this.on1 + " = " + this.on2;
    }

    public String toSql(Dialect dialect) {
        switch (this.kind) {
            case 1: {
                return String.format(" JOIN %s ON %s", this.getTable(dialect), this.getClause(dialect));
            }
            case 2: {
                return String.format(" LEFT JOIN %s ON %s", this.getTable(dialect), this.getClause(dialect));
            }
            case 3: {
                return String.format(" RIGHT JOIN %s ON %s", this.getTable(dialect), this.getClause(dialect));
            }
            case 4: {
                return String.format(", %s", this.getTable(dialect));
            }
        }
        throw new AssertionError();
    }

    public String toString() {
        String k;
        switch (this.kind) {
            case 1: {
                k = "INNER";
                break;
            }
            case 2: {
                k = "LEFT";
                break;
            }
            case 3: {
                k = "RIGHT";
                break;
            }
            case 4: {
                k = "IMPLICIT";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(k);
        sb.append(" JOIN ");
        sb.append(this.table);
        if (this.tableAlias != null) {
            sb.append(" ");
            sb.append(this.tableAlias);
        }
        sb.append(" ON ");
        sb.append(this.getClause(null));
        if (!this.whereClauses.isEmpty()) {
            sb.append(" WHERE ");
            sb.append(this.whereClauses);
            sb.append(" % ");
            sb.append(this.whereParams);
        }
        sb.append(">");
        return sb.toString();
    }
}

