/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc.dialect;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.model.BaseSession;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.storage.FulltextQueryAnalyzer;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCLogger;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Join;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;

public class DialectOracle
extends Dialect {
    private static final Log log = LogFactory.getLog(DialectOracle.class);
    private Constructor<?> arrayDescriptorConstructor;
    private Constructor<?> arrayConstructor;
    private Method arrayGetLongArrayMethod;
    protected Class<PreparedStatement> oraclePreparedStatementClass;
    protected Method oraclePreparedStatementRegisterReturnParameter;
    protected Method oraclePreparedStatementGetReturnResultSet;
    protected final String fulltextParameters;
    protected boolean pathOptimizationsEnabled;
    protected int pathOptimizationsVersion = 0;
    protected final boolean disableVersionACL;
    protected final boolean disableReadVersionPermission;
    private static final String DEFAULT_USERS_SEPARATOR = "|";
    protected String usersSeparator;
    protected final Dialect.DialectIdType idType;
    protected String idSequenceName;
    protected int majorVersion;
    protected XAErrorLogger xaErrorLogger;
    protected static final String CHARS_RESERVED_STR = "%${";
    protected static final Set<Character> CHARS_RESERVED = new HashSet<Character>(Arrays.asList(ArrayUtils.toObject((char[])"%${".toCharArray())));

    public DialectOracle(DatabaseMetaData metadata, RepositoryDescriptor repositoryDescriptor) {
        super(metadata, repositoryDescriptor);
        String idt;
        try {
            this.majorVersion = metadata.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
        this.fulltextParameters = repositoryDescriptor == null ? null : (repositoryDescriptor.getFulltextAnalyzer() == null ? "" : repositoryDescriptor.getFulltextAnalyzer());
        boolean bl = this.pathOptimizationsEnabled = repositoryDescriptor != null && repositoryDescriptor.getPathOptimizationsEnabled();
        if (this.pathOptimizationsEnabled) {
            this.pathOptimizationsVersion = repositoryDescriptor.getPathOptimizationsVersion();
        }
        this.disableVersionACL = BaseSession.VersionAclMode.getConfiguration() == BaseSession.VersionAclMode.DISABLED;
        this.disableReadVersionPermission = BaseSession.isReadVersionPermissionDisabled();
        this.usersSeparator = repositoryDescriptor == null ? null : (repositoryDescriptor.usersSeparatorKey == null ? DEFAULT_USERS_SEPARATOR : repositoryDescriptor.usersSeparatorKey);
        String string = idt = repositoryDescriptor == null ? null : repositoryDescriptor.idType;
        if (idt == null || "".equals(idt) || "varchar".equalsIgnoreCase(idt)) {
            this.idType = Dialect.DialectIdType.VARCHAR;
        } else if (idt.toLowerCase().startsWith("sequence")) {
            this.idType = Dialect.DialectIdType.SEQUENCE;
            if (idt.toLowerCase().startsWith("sequence:")) {
                String[] split = idt.split(":");
                this.idSequenceName = split[1].toUpperCase(Locale.ENGLISH);
            } else {
                this.idSequenceName = "HIERARCHY_SEQ";
            }
        } else {
            throw new NuxeoException("Unknown id type: '" + idt + "'");
        }
        this.xaErrorLogger = this.newXAErrorLogger();
        this.initReflection();
    }

    protected XAErrorLogger newXAErrorLogger() {
        try {
            return new XAErrorLogger();
        }
        catch (ReflectiveOperationException e) {
            log.warn((Object)"Cannot initialize xa error loggger", (Throwable)e);
            return null;
        }
    }

    private void initReflection() {
        try {
            Class<?> arrayDescriptorClass = Class.forName("oracle.sql.ArrayDescriptor");
            this.arrayDescriptorConstructor = arrayDescriptorClass.getConstructor(String.class, Connection.class);
            Class<?> arrayClass = Class.forName("oracle.sql.ARRAY");
            this.arrayConstructor = arrayClass.getConstructor(arrayDescriptorClass, Connection.class, Object.class);
            this.arrayGetLongArrayMethod = arrayClass.getDeclaredMethod("getLongArray", new Class[0]);
            Class<?> opsClass = Class.forName("oracle.jdbc.OraclePreparedStatement");
            this.oraclePreparedStatementClass = opsClass;
            this.oraclePreparedStatementRegisterReturnParameter = opsClass.getMethod("registerReturnParameter", Integer.TYPE, Integer.TYPE);
            this.oraclePreparedStatementGetReturnResultSet = opsClass.getMethod("getReturnResultSet", new Class[0]);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void registerReturnParameter(PreparedStatement ps, int parameterIndex, int sqlType) throws SQLException {
        PreparedStatement ops = ps.unwrap(this.oraclePreparedStatementClass);
        try {
            this.oraclePreparedStatementRegisterReturnParameter.invoke((Object)ops, parameterIndex, sqlType);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public ResultSet getReturnResultSet(PreparedStatement ps) throws SQLException {
        PreparedStatement ops = ps.unwrap(this.oraclePreparedStatementClass);
        try {
            return (ResultSet)this.oraclePreparedStatementGetReturnResultSet.invoke((Object)ops, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public String getNoColumnsInsertString(Column idColumn) {
        return String.format("(%s) VALUES (DEFAULT)", idColumn.getQuotedName());
    }

    @Override
    public String getConnectionSchema(Connection connection) throws SQLException {
        String user;
        try (Statement st = connection.createStatement();){
            String sql = "SELECT SYS_CONTEXT('USERENV', 'SESSION_USER') FROM DUAL";
            log.trace((Object)("SQL: " + sql));
            try (ResultSet rs = st.executeQuery(sql);){
                rs.next();
                user = rs.getString(1);
            }
        }
        log.trace((Object)("SQL:   -> " + user));
        return user;
    }

    @Override
    public String getCascadeDropConstraintsString() {
        return " CASCADE CONSTRAINTS";
    }

    @Override
    public String getAddColumnString() {
        return "ADD";
    }

    @Override
    public Dialect.JDBCInfo getJDBCTypeAndString(ColumnType type) {
        switch (type.spec) {
            case STRING: {
                if (type.isUnconstrained()) {
                    return DialectOracle.jdbcInfo("NVARCHAR2(2000)", 12);
                }
                if (type.isClob() || type.length > 2000) {
                    return DialectOracle.jdbcInfo("NCLOB", 2005);
                }
                return DialectOracle.jdbcInfo("NVARCHAR2(%d)", type.length, 12);
            }
            case BOOLEAN: {
                return DialectOracle.jdbcInfo("NUMBER(1,0)", -7);
            }
            case LONG: {
                return DialectOracle.jdbcInfo("NUMBER(19,0)", -5);
            }
            case DOUBLE: {
                return DialectOracle.jdbcInfo("DOUBLE PRECISION", 8);
            }
            case TIMESTAMP: {
                return DialectOracle.jdbcInfo("TIMESTAMP", 93);
            }
            case BLOBID: {
                return DialectOracle.jdbcInfo("VARCHAR2(250)", 12);
            }
            case BLOB: {
                return DialectOracle.jdbcInfo("BLOB", 2004);
            }
            case NODEID: 
            case NODEIDFK: 
            case NODEIDFKNP: 
            case NODEIDFKMUL: 
            case NODEIDFKNULL: 
            case NODEIDPK: 
            case NODEVAL: {
                switch (this.idType) {
                    case VARCHAR: {
                        return DialectOracle.jdbcInfo("VARCHAR2(36)", 12);
                    }
                    case SEQUENCE: {
                        return DialectOracle.jdbcInfo("NUMBER(10,0)", 4);
                    }
                }
                throw new AssertionError((Object)("Unknown id type: " + this.idType));
            }
            case SYSNAME: 
            case SYSNAMEARRAY: {
                return DialectOracle.jdbcInfo("VARCHAR2(250)", 12);
            }
            case TINYINT: {
                return DialectOracle.jdbcInfo("NUMBER(3,0)", -6);
            }
            case INTEGER: {
                return DialectOracle.jdbcInfo("NUMBER(10,0)", 4);
            }
            case AUTOINC: {
                return DialectOracle.jdbcInfo("NUMBER(10,0)", 4);
            }
            case FTINDEXED: {
                return DialectOracle.jdbcInfo("CLOB", 2005);
            }
            case FTSTORED: {
                return DialectOracle.jdbcInfo("NCLOB", 2005);
            }
            case CLUSTERNODE: {
                return DialectOracle.jdbcInfo("VARCHAR(25)", 12);
            }
            case CLUSTERFRAGS: {
                return DialectOracle.jdbcInfo("VARCHAR2(4000)", 12);
            }
        }
        throw new AssertionError(type);
    }

    @Override
    public boolean isAllowedConversion(int expected, int actual, String actualName, int actualSize) {
        if (expected == 8 && actual == 6) {
            return true;
        }
        if (expected == 12 && actual == -9) {
            return true;
        }
        if (expected == 12 && actual == 1111 && actualName.equals("NVARCHAR2")) {
            return true;
        }
        if (expected == 2005 && actual == 2011) {
            return true;
        }
        if (expected == 2005 && actual == 1111 && actualName.equals("NCLOB")) {
            return true;
        }
        if (expected == -7 && (actual == 3 || actual == 2) && actualSize == 1) {
            return true;
        }
        if (expected == -6 && (actual == 3 || actual == 2) && actualSize == 3) {
            return true;
        }
        if (expected == 4 && (actual == 3 || actual == 2) && actualSize == 10) {
            return true;
        }
        if (expected == -5 && (actual == 3 || actual == 2) && actualSize == 19) {
            return true;
        }
        if (expected == -5 && (actual == 3 || actual == 2) && actualSize == 38) {
            return true;
        }
        if (expected == 12 && actual == 2011) {
            return true;
        }
        if (expected == 12 && actual == 1111 && actualName.equals("NCLOB")) {
            return true;
        }
        if (expected == 2005 && actual == 12) {
            return true;
        }
        if (expected == 2005 && actual == -9) {
            return true;
        }
        return expected == 2005 && actual == 1111 && actualName.equals("NVARCHAR2");
    }

    @Override
    public Serializable getGeneratedId(Connection connection) throws SQLException {
        if (this.idType != Dialect.DialectIdType.SEQUENCE) {
            return super.getGeneratedId(connection);
        }
        String sql = String.format("SELECT %s.NEXTVAL FROM DUAL", this.idSequenceName);
        try (Statement s = connection.createStatement();){
            Long l;
            block13: {
                ResultSet rs = s.executeQuery(sql);
                try {
                    rs.next();
                    l = rs.getLong(1);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return l;
        }
    }

    @Override
    public void setId(PreparedStatement ps, int index, Serializable value) throws SQLException {
        switch (this.idType) {
            case VARCHAR: {
                ps.setObject(index, value);
                break;
            }
            case SEQUENCE: {
                this.setIdLong(ps, index, value);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown id type: " + this.idType));
            }
        }
    }

    @Override
    public void setToPreparedStatement(PreparedStatement ps, int index, Serializable value, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: 
            case 2005: {
                this.setToPreparedStatementString(ps, index, value, column);
                return;
            }
            case -7: {
                ps.setBoolean(index, (Boolean)value);
                return;
            }
            case -6: 
            case 5: {
                ps.setInt(index, ((Long)value).intValue());
                return;
            }
            case -5: 
            case 4: {
                ps.setLong(index, ((Number)value).longValue());
                return;
            }
            case 8: {
                ps.setDouble(index, (Double)value);
                return;
            }
            case 93: {
                this.setToPreparedStatementTimestamp(ps, index, value, column);
                return;
            }
            case 2004: {
                ps.setBytes(index, (byte[])value);
                return;
            }
            case 1111: {
                ColumnType type = column.getType();
                if (type.isId()) {
                    this.setId(ps, index, value);
                    return;
                }
                if (type == ColumnType.FTSTORED) {
                    ps.setString(index, (String)((Object)value));
                    return;
                }
                throw new SQLException("Unhandled type: " + column.getType());
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    public Serializable getFromResultSet(ResultSet rs, int index, Column column) throws SQLException {
        switch (column.getJdbcType()) {
            case 12: {
                return this.getFromResultSetString(rs, index, column);
            }
            case 2005: {
                Reader r = rs.getCharacterStream(index);
                if (r == null) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                try {
                    int n;
                    char[] buffer = new char[4096];
                    while ((n = r.read(buffer)) != -1) {
                        sb.append(new String(buffer, 0, n));
                    }
                }
                catch (IOException e) {
                    log.error((Object)"Cannot read CLOB", (Throwable)e);
                }
                return sb.toString();
            }
            case -7: {
                return Boolean.valueOf(rs.getBoolean(index));
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return Long.valueOf(rs.getLong(index));
            }
            case 8: {
                return Double.valueOf(rs.getDouble(index));
            }
            case 93: {
                return this.getFromResultSetTimestamp(rs, index, column);
            }
            case 2004: {
                return rs.getBytes(index);
            }
        }
        throw new SQLException("Unhandled JDBC type: " + column.getJdbcType());
    }

    @Override
    protected int getMaxNameSize() {
        return 30;
    }

    @Override
    protected int getMaxIndexNameSize() {
        return 25;
    }

    @Override
    public String getCreateFulltextIndexSql(String indexName, String quotedIndexName, Table table, List<Column> columns, Model model) {
        return String.format("CREATE INDEX %s ON %s(%s) INDEXTYPE IS CTXSYS.CONTEXT PARAMETERS('%s SYNC (ON COMMIT) TRANSACTIONAL')", quotedIndexName, table.getQuotedName(), columns.get(0).getQuotedName(), this.fulltextParameters);
    }

    @Override
    public String getDialectFulltextQuery(String query) {
        FulltextQueryAnalyzer.FulltextQuery ft = FulltextQueryAnalyzer.analyzeFulltextQuery((String)(query = query.replace("*", "%")));
        if (ft == null) {
            return "DONTMATCHANYTHINGFOREMPTYQUERY";
        }
        return FulltextQueryAnalyzer.translateFulltext((FulltextQueryAnalyzer.FulltextQuery)ft, (String)"OR", (String)"AND", (String)"NOT", (String)"{", (String)"}", CHARS_RESERVED, (String)"", (String)"", (boolean)true);
    }

    @Override
    public Dialect.FulltextMatchInfo getFulltextScoredMatchInfo(String fulltextQuery, String indexName, int nthMatch, Column mainColumn, Model model, Database database) {
        String indexSuffix = model.getFulltextIndexSuffix(indexName);
        Table ft = database.getTable("fulltext");
        Column ftMain = ft.getColumn("id");
        Column ftColumn = ft.getColumn("fulltext" + indexSuffix);
        String score = String.format("SCORE(%d)", nthMatch);
        String nthSuffix = nthMatch == 1 ? "" : String.valueOf(nthMatch);
        Dialect.FulltextMatchInfo info = new Dialect.FulltextMatchInfo();
        if (nthMatch == 1) {
            info.joins = Collections.singletonList(new Join(1, ft.getQuotedName(), null, null, ftMain.getFullQuotedName(), mainColumn.getFullQuotedName()));
        }
        info.whereExpr = String.format("CONTAINS(%s, ?, %d) > 0", ftColumn.getFullQuotedName(), nthMatch);
        info.whereExprParam = fulltextQuery;
        info.scoreExpr = String.format("(%s / 100)", score);
        info.scoreAlias = this.openQuote() + "_nxscore" + nthSuffix + this.closeQuote();
        info.scoreCol = new Column(mainColumn.getTable(), null, ColumnType.DOUBLE, null);
        return info;
    }

    @Override
    public boolean getMaterializeFulltextSyntheticColumn() {
        return true;
    }

    @Override
    public int getFulltextIndexedColumns() {
        return 1;
    }

    @Override
    public String getLikeEscaping() {
        return " ESCAPE '\\'";
    }

    @Override
    public boolean supportsUpdateFrom() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean doesUpdateFromRepeatSelf() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean needsOriginalColumnInGroupBy() {
        return true;
    }

    @Override
    public boolean needsOracleJoins() {
        return true;
    }

    @Override
    public String getClobCast(boolean inOrderBy) {
        return "CAST(%s AS NVARCHAR2(%d))";
    }

    @Override
    public String getQuotedNameForExpression(Column column) {
        Object sql = super.getQuotedNameForExpression(column);
        if (column.getJdbcType() == 2005) {
            sql = "TO_CHAR(" + (String)sql + ")";
        }
        return sql;
    }

    @Override
    public boolean supportsReadAcl() {
        return this.aclOptimizationsEnabled;
    }

    @Override
    public String getPrepareUserReadAclsSql() {
        return "{CALL nx_prepare_user_read_acls(?)}";
    }

    @Override
    public String getReadAclsCheckSql(String userIdCol) {
        return String.format("%s = nx_hash_users(?)", userIdCol);
    }

    @Override
    public String getUpdateReadAclsSql() {
        return "{CALL nx_update_read_acls}";
    }

    @Override
    public String getRebuildReadAclsSql() {
        return "{CALL nx_rebuild_read_acls}";
    }

    @Override
    public String getSecurityCheckSql(String idColumnName) {
        return String.format("NX_ACCESS_ALLOWED(%s, ?, ?) = 1", idColumnName);
    }

    @Override
    public boolean supportsFastDescendants() {
        return this.pathOptimizationsEnabled;
    }

    @Override
    public String getInTreeSql(String idColumnName, String id) {
        String idParam;
        switch (this.idType) {
            case VARCHAR: {
                idParam = "?";
                break;
            }
            case SEQUENCE: {
                if (id != null && !StringUtils.isNumeric((CharSequence)id)) {
                    return null;
                }
                idParam = "CAST(? AS NUMBER(10,0))";
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown id type: " + this.idType));
            }
        }
        if (this.pathOptimizationsVersion == 2) {
            return String.format("EXISTS(SELECT 1 FROM ancestors WHERE hierarchy_id = %s AND ancestor = %s)", idColumnName, idParam);
        }
        if (this.pathOptimizationsVersion == 1) {
            return String.format("EXISTS(SELECT 1 FROM ancestors WHERE hierarchy_id = %s AND %s MEMBER OF ancestors)", idColumnName, idParam);
        }
        return String.format("%s in (SELECT id FROM hierarchy WHERE LEVEL>1 AND isproperty = 0 START WITH id = %s CONNECT BY PRIOR id = parentid)", idColumnName, idParam);
    }

    @Override
    public String getUpsertSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues) {
        return this.getMergeSql(columns, values, outColumns, outValues, true);
    }

    @Override
    public String getInsertOnConflictDoNothingSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues) {
        return this.getMergeSql(columns, values, outColumns, outValues, false);
    }

    protected String getMergeSql(List<Column> columns, List<Serializable> values, List<Column> outColumns, List<Serializable> outValues, boolean updateWhenMatched) {
        int i;
        Column keyColumn = columns.get(0);
        Serializable keyValue = values.get(0);
        Table table = keyColumn.getTable();
        StringBuilder sql = new StringBuilder();
        sql.append("MERGE INTO ");
        sql.append(table.getQuotedName());
        sql.append(" USING DUAL ON (");
        sql.append(keyColumn.getQuotedName());
        sql.append(" = ?)");
        outColumns.add(keyColumn);
        outValues.add(keyValue);
        if (updateWhenMatched) {
            sql.append(" WHEN MATCHED THEN UPDATE SET ");
            for (i = 1; i < columns.size(); ++i) {
                if (i != 1) {
                    sql.append(", ");
                }
                sql.append(columns.get(i).getQuotedName());
                sql.append(" = ?");
                outColumns.add(columns.get(i));
                outValues.add(values.get(i));
            }
        }
        sql.append(" WHEN NOT MATCHED THEN INSERT (");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append(columns.get(i).getQuotedName());
        }
        sql.append(") VALUES (");
        for (i = 0; i < columns.size(); ++i) {
            if (i != 0) {
                sql.append(", ");
            }
            sql.append("?");
            outColumns.add(columns.get(i));
            outValues.add(values.get(i));
        }
        sql.append(")");
        return sql.toString();
    }

    @Override
    public boolean isClusteringSupported() {
        return true;
    }

    @Override
    public boolean isClusteringDeleteNeeded() {
        return true;
    }

    @Override
    public String getClusterInsertInvalidations() {
        return "{CALL NX_CLUSTER_INVAL(?, ?, ?, ?)}";
    }

    @Override
    public String getClusterGetInvalidations() {
        return "SELECT id, fragments, kind FROM cluster_invals WHERE nodeid = ?";
    }

    @Override
    public boolean supportsPaging() {
        return true;
    }

    @Override
    public String addPagingClause(String sql, long limit, long offset) {
        return String.format("SELECT * FROM (SELECT /*+ FIRST_ROWS(%d) */  a.*, ROWNUM rnum FROM (%s) a WHERE ROWNUM <= %d) WHERE rnum  > %d", limit, sql, limit + offset, offset);
    }

    @Override
    public boolean supportsWith() {
        return false;
    }

    @Override
    public boolean supportsArrays() {
        return true;
    }

    @Override
    public boolean supportsArraysReturnInsteadOfRows() {
        return true;
    }

    @Override
    public Serializable[] getArrayResult(Array array) throws SQLException {
        Serializable[] ids;
        if (array.getBaseType() == 2) {
            long[] longs;
            try {
                longs = (long[])this.arrayGetLongArrayMethod.invoke((Object)array, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            ids = new Serializable[longs.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = Long.valueOf(longs[i]);
            }
        } else {
            ids = (Serializable[])array.getArray();
        }
        return ids;
    }

    @Override
    public boolean hasNullEmptyString() {
        return true;
    }

    @Override
    public Array createArrayOf(int type, Object[] elements, Connection connection) throws SQLException {
        String typeName;
        if (elements == null || elements.length == 0) {
            return null;
        }
        block1 : switch (type) {
            case 12: {
                typeName = "NX_STRING_TABLE";
                break;
            }
            case 1111: {
                switch (this.idType) {
                    case VARCHAR: {
                        typeName = "NX_STRING_TABLE";
                        break block1;
                    }
                    case SEQUENCE: {
                        typeName = "NX_INT_TABLE";
                        break block1;
                    }
                }
                throw new AssertionError((Object)("Unknown id type: " + this.idType));
            }
            default: {
                throw new AssertionError((Object)("Unknown type: " + type));
            }
        }
        Connection unwrappedConnection = ConnectionHelper.unwrap((Connection)connection);
        try {
            Object arrayDescriptor = this.arrayDescriptorConstructor.newInstance(typeName, unwrappedConnection);
            return (Array)this.arrayConstructor.newInstance(arrayDescriptor, unwrappedConnection, elements);
        }
        catch (ReflectiveOperationException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getSQLStatementsFilename() {
        return "nuxeovcs/oracle.sql.txt";
    }

    @Override
    public String getTestSQLStatementsFilename() {
        return "nuxeovcs/oracle.test.sql.txt";
    }

    @Override
    public Map<String, Serializable> getSQLStatementsProperties(Model model, Database database) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        switch (this.idType) {
            case VARCHAR: {
                properties.put("idType", (Serializable)((Object)"VARCHAR2(36)"));
                properties.put("idTypeParam", (Serializable)((Object)"VARCHAR2"));
                properties.put("idArrayType", (Serializable)((Object)"NX_STRING_TABLE"));
                properties.put("idNotPresent", (Serializable)((Object)"'-'"));
                properties.put("sequenceEnabled", Boolean.FALSE);
                break;
            }
            case SEQUENCE: {
                properties.put("idType", (Serializable)((Object)"NUMBER(10,0)"));
                properties.put("idTypeParam", (Serializable)((Object)"NUMBER"));
                properties.put("idArrayType", (Serializable)((Object)"NX_INT_TABLE"));
                properties.put("idNotPresent", (Serializable)((Object)"-1"));
                properties.put("sequenceEnabled", Boolean.TRUE);
                properties.put("idSequenceName", (Serializable)((Object)this.idSequenceName));
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown id type: " + this.idType));
            }
        }
        properties.put("aclOptimizationsEnabled", Boolean.valueOf(this.aclOptimizationsEnabled));
        properties.put("pathOptimizationsEnabled", Boolean.valueOf(this.pathOptimizationsEnabled));
        properties.put("pathOptimizationsVersion1", Boolean.valueOf(this.pathOptimizationsVersion == 1));
        properties.put("pathOptimizationsVersion2", Boolean.valueOf(this.pathOptimizationsVersion == 2));
        properties.put("fulltextEnabled", Boolean.valueOf(!this.fulltextDisabled));
        properties.put("fulltextSearchEnabled", Boolean.valueOf(!this.fulltextSearchDisabled));
        properties.put("clusteringEnabled", Boolean.valueOf(this.clusteringEnabled));
        properties.put("proxiesEnabled", Boolean.valueOf(this.proxiesEnabled));
        properties.put("softDeleteEnabled", Boolean.valueOf(this.softDeleteEnabled));
        properties.put("disableVersionACL", Boolean.valueOf(this.disableVersionACL));
        properties.put("disableReadVersionPermission", Boolean.valueOf(this.disableReadVersionPermission));
        if (!this.fulltextSearchDisabled) {
            Table ft = database.getTable("fulltext");
            properties.put("fulltextTable", (Serializable)((Object)ft.getQuotedName()));
            FulltextConfiguration fti = model.getFulltextConfiguration();
            ArrayList<String> lines = new ArrayList<String>(fti.indexNames.size());
            for (String indexName : fti.indexNames) {
                String suffix = model.getFulltextIndexSuffix(indexName);
                Column ftft = ft.getColumn("fulltext" + suffix);
                Column ftst = ft.getColumn("simpletext" + suffix);
                Column ftbt = ft.getColumn("binarytext" + suffix);
                String line = String.format("  :NEW.%s := :NEW.%s || ' ' || :NEW.%s; ", ftft.getQuotedName(), ftst.getQuotedName(), ftbt.getQuotedName());
                lines.add(line);
            }
            properties.put("fulltextTriggerStatements", (Serializable)((Object)String.join((CharSequence)"\n", lines)));
        }
        String[] permissions = ((SecurityService)Framework.getService(SecurityService.class)).getPermissionsToCheck("Browse");
        LinkedList<String> permsList = new LinkedList<String>();
        for (String perm : permissions) {
            permsList.add(String.format("  INTO ACLR_PERMISSION VALUES ('%s')", perm));
        }
        properties.put("readPermissions", (Serializable)((Object)String.join((CharSequence)"\n", permsList)));
        properties.put("usersSeparator", (Serializable)((Object)this.getUsersSeparator()));
        properties.put("everyone", (Serializable)((Object)"Everyone"));
        return properties;
    }

    protected int getOracleErrorCode(Throwable t) {
        try {
            int errorCode;
            Method m = t.getClass().getMethod("getOracleError", new Class[0]);
            Integer oracleError = (Integer)m.invoke((Object)t, new Object[0]);
            if (oracleError != null && (errorCode = oracleError.intValue()) != 0) {
                return errorCode;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        if (t instanceof SQLException) {
            return ((SQLException)t).getErrorCode();
        }
        return 0;
    }

    protected boolean isConnectionClosed(int oracleError) {
        switch (oracleError) {
            case 28: 
            case 1033: 
            case 1034: 
            case 1041: 
            case 1089: 
            case 1090: 
            case 3113: 
            case 3114: 
            case 12571: 
            case 17002: 
            case 17008: 
            case 17410: 
            case 24768: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConcurrentUpdateException(Throwable t) {
        Throwable cause;
        while ((cause = t.getCause()) != null && cause instanceof SQLException) {
            t = cause;
        }
        switch (this.getOracleErrorCode(t)) {
            case 1: 
            case 60: 
            case 1403: 
            case 2291: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getValidationQuery() {
        return "SELECT 1 FROM DUAL";
    }

    @Override
    public String getBlobLengthFunction() {
        return "LENGTHB";
    }

    @Override
    public List<String> getPostCreateIdentityColumnSql(Column column) {
        String table = column.getTable().getPhysicalName();
        String col = column.getPhysicalName();
        String seq = table + "_IDSEQ";
        String trig = table + "_IDTRIG";
        String createSeq = String.format("CREATE SEQUENCE \"%s\"", seq);
        String createTrig = String.format("CREATE TRIGGER \"%s\"\n  BEFORE INSERT ON \"%s\"\n  FOR EACH ROW WHEN (NEW.\"%s\" IS NULL)\nBEGIN\n  SELECT \"%s\".NEXTVAL INTO :NEW.\"%s\" FROM DUAL;\nEND;", trig, table, col, seq, col);
        return Arrays.asList(createSeq, createTrig);
    }

    @Override
    public boolean hasIdentityGeneratedKey() {
        return false;
    }

    @Override
    public String getIdentityGeneratedKeySql(Column column) {
        String table = column.getTable().getPhysicalName();
        String seq = table + "_IDSEQ";
        return String.format("SELECT \"%s\".CURRVAL FROM DUAL", seq);
    }

    @Override
    public String getAncestorsIdsSql() {
        return "SELECT NX_ANCESTORS(?) FROM DUAL";
    }

    @Override
    public boolean needsNullsLastOnDescSort() {
        return true;
    }

    @Override
    public String getDateCast() {
        return "TRUNC(%s)";
    }

    @Override
    public String castIdToVarchar(String expr) {
        switch (this.idType) {
            case VARCHAR: {
                return expr;
            }
            case SEQUENCE: {
                return "CAST(" + expr + " AS VARCHAR2(36))";
            }
        }
        throw new AssertionError((Object)("Unknown id type: " + this.idType));
    }

    @Override
    public Dialect.DialectIdType getIdType() {
        return this.idType;
    }

    public String getUsersSeparator() {
        if (this.usersSeparator == null) {
            return DEFAULT_USERS_SEPARATOR;
        }
        return this.usersSeparator;
    }

    @Override
    public String getSoftDeleteSql() {
        return "{CALL NX_DELETE(?, ?)}";
    }

    @Override
    public String getSoftDeleteCleanupSql() {
        return "{CALL NX_DELETE_PURGE(?, ?, ?)}";
    }

    @Override
    public List<String> getStartupSqls(Model model, Database database) {
        if (this.aclOptimizationsEnabled) {
            log.info((Object)"Vacuuming tables used by optimized acls");
            return Collections.singletonList("{CALL nx_vacuum_read_acls}");
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> checkStoredProcedure(String procName, String procCreate, String ddlMode, Connection connection, JDBCLogger logger, Map<String, Serializable> properties) throws SQLException {
        boolean compatCheck = ddlMode.contains("compat");
        if (compatCheck) {
            procCreate = "CREATE OR REPLACE " + ((String)procCreate).substring("create ".length());
            return Collections.singletonList(procCreate);
        }
        try (Statement st = connection.createStatement();){
            List<Object> list;
            block23: {
                ResultSet rs;
                block19: {
                    List<Object> list2;
                    block22: {
                        block20: {
                            List<String> list3;
                            block21: {
                                String getBody = ((String)procCreate).toLowerCase().startsWith("create trigger ") ? "SELECT TRIGGER_BODY FROM USER_TRIGGERS WHERE TRIGGER_NAME = '" + procName + "'" : "SELECT TEXT FROM ALL_SOURCE WHERE NAME = '" + procName + "' ORDER BY LINE";
                                logger.log(getBody);
                                rs = st.executeQuery(getBody);
                                try {
                                    if (!rs.next()) break block19;
                                    ArrayList<String> lines = new ArrayList<String>();
                                    do {
                                        lines.add(rs.getString(1));
                                    } while (rs.next());
                                    String body = StringUtils.join(lines, (char)' ');
                                    if (!DialectOracle.normalizeString((String)procCreate).contains(DialectOracle.normalizeString(body))) break block20;
                                    logger.log("  -> exists, unchanged");
                                    list3 = Collections.emptyList();
                                    if (rs == null) break block21;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return list3;
                        }
                        logger.log("  -> exists, old");
                        if (!((String)procCreate).toLowerCase().startsWith("create ")) {
                            throw new NuxeoException("Should start with CREATE: " + (String)procCreate);
                        }
                        procCreate = "CREATE OR REPLACE " + ((String)procCreate).substring("create ".length());
                        list2 = Collections.singletonList(procCreate);
                        if (rs == null) break block22;
                        rs.close();
                    }
                    return list2;
                }
                logger.log("  -> missing");
                list = Collections.singletonList(procCreate);
                if (rs == null) break block23;
                rs.close();
            }
            return list;
        }
    }

    protected static String normalizeString(String string) {
        return string.replaceAll("[ \n\r\t]+", " ").trim();
    }

    @Override
    public String getSQLForDump(String sql) {
        String sqll = ((String)sql).toLowerCase();
        if (sqll.startsWith("{call ")) {
            return "EXECUTE " + ((String)sql).substring("{call ".length(), ((String)sql).length() - 1);
        }
        if (sqll.endsWith("end")) {
            sql = (String)sql + ";";
        }
        return (String)sql + "\n/";
    }

    @Override
    public boolean supportsBatchUpdateCount() {
        return this.majorVersion >= 12;
    }

    protected static class XAErrorLogger {
        protected final Class<?> oracleXAExceptionClass = Thread.currentThread().getContextClassLoader().loadClass("oracle.jdbc.xa.OracleXAException");
        protected final Method m_xaError = this.oracleXAExceptionClass.getMethod("getXAError", new Class[0]);
        protected final Method m_xaErrorMessage = this.oracleXAExceptionClass.getMethod("getXAErrorMessage", this.m_xaError.getReturnType());
        protected final Method m_oracleError = this.oracleXAExceptionClass.getMethod("getOracleError", new Class[0]);
        protected final Method m_oracleSQLError = this.oracleXAExceptionClass.getMethod("getOracleSQLError", new Class[0]);

        public void log(XAException e) throws ReflectiveOperationException {
            int xaError = (Integer)this.m_xaError.invoke((Object)e, new Object[0]);
            String xaErrorMessage = (String)this.m_xaErrorMessage.invoke((Object)xaError, new Object[0]);
            int oracleError = (Integer)this.m_oracleError.invoke((Object)e, new Object[0]);
            int oracleSQLError = (Integer)this.m_oracleSQLError.invoke((Object)e, new Object[0]);
            StringBuilder builder = new StringBuilder();
            builder.append("Oracle XA Error : ").append(xaError).append(" (").append(xaErrorMessage).append("),");
            builder.append("Oracle Error : ").append(oracleError).append(",");
            builder.append("Oracle SQL Error : ").append(oracleSQLError);
            log.warn((Object)builder.toString(), (Throwable)e);
        }
    }
}

