/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.cudf.metadata;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;
    private static final String SEPARATOR = ".";
    public static final Version emptyVersion = new Version(0, 0, 0);
    public static final Version maxVersion = new Version(Integer.MAX_VALUE);

    public Version(int major) {
        this.major = major;
        this.minor = 0;
        this.micro = 0;
        this.qualifier = "";
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String qualifier) {
        if (qualifier == null) {
            qualifier = "";
        }
        this.major = major;
        this.minor = 0;
        this.micro = 0;
        this.qualifier = qualifier;
    }

    public Version(String version) {
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            this.major = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                st.nextToken();
                this.minor = Integer.parseInt(st.nextToken());
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    this.micro = Integer.parseInt(st.nextToken());
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        this.qualifier = st.nextToken();
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("invalid format");
                        }
                    } else {
                        this.qualifier = "";
                    }
                } else {
                    this.micro = 0;
                    this.qualifier = "";
                }
            } else {
                this.minor = 0;
                this.micro = 0;
                this.qualifier = "";
            }
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("invalid format");
        }
    }

    public static Version parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        if ((version = version.trim()).length() == 0) {
            return emptyVersion;
        }
        return new Version(version);
    }

    public int getMajor() {
        return this.major;
    }

    public String toString() {
        return Integer.toString(this.major);
    }

    public int hashCode() {
        return this.major << 24;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.major == other.major;
    }

    @Override
    public int compareTo(Version other) {
        if (other == this) {
            return 0;
        }
        return this.major - other.major;
    }
}

