/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.service;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.platform.mimetype.MimetypeEntryImpl;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;

@XObject(value="mimetype")
@XRegistry(compatWarnOnMerge=true)
public class MimetypeDescriptor {
    @XNode(value="@normalized")
    @XRegistryId
    protected String normalized;
    @XNode(value="@binary")
    protected boolean binary = true;
    @XNode(value="@onlineEditable")
    protected boolean onlineEditable = false;
    @XNode(value="@oleSupported")
    protected boolean oleSupported = false;
    @XNode(value="@iconPath")
    protected String iconPath;
    @XNodeList(value="mimetypes/mimetype", type=LinkedHashSet.class, componentType=String.class)
    protected Set<String> mimetypes;
    @XNodeList(value="extensions/extension", type=LinkedHashSet.class, componentType=String.class)
    protected Set<String> extensions;

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isOnlineEditable() {
        return this.onlineEditable;
    }

    public boolean isOleSupported() {
        return this.oleSupported;
    }

    public List<String> getExtensions() {
        return new ArrayList<String>(this.extensions);
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public List<String> getMimetypes() {
        return new ArrayList<String>(this.mimetypes);
    }

    public MimetypeEntry getMimetype() {
        return new MimetypeEntryImpl(this.normalized, this.getMimetypes(), this.getExtensions(), this.iconPath, this.binary, this.onlineEditable, this.oleSupported);
    }

    public String getNormalized() {
        return this.normalized;
    }
}

