/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.io.Serializable;
import java.util.Set;
import java.util.function.Supplier;

public interface Cache {
    public String getName();

    public Serializable get(String var1);

    default public <V extends Serializable> V computeIfAbsent(String key, Supplier<V> supplier) {
        Serializable value = this.get(key);
        if (value == null) {
            value = (Serializable)supplier.get();
            this.put(key, value);
        }
        return (V)value;
    }

    public Set<String> keySet();

    public void invalidate(String var1);

    public void invalidateAll();

    public void put(String var1, Serializable var2);

    default public boolean hasEntry(String key) {
        return this.get(key) != null;
    }
}

