/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.core.cache.CacheManagement;

@XObject(value="cache")
@XRegistry
public class CacheDescriptor {
    public static final long DEFAULT_TTL = 1L;
    public static final long DEFAULT_MAX_SIZE = 100L;
    public static final String OPTION_MAX_SIZE = "maxSize";
    public static final String OPTION_CONCURRENCY_LEVEL = "concurrencyLevel";
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@class")
    protected Class<? extends CacheManagement> klass;
    @XNode(value="ttl")
    protected Long ttl;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    protected Map<String, String> options = new HashMap<String, String>();

    public CacheDescriptor() {
    }

    public CacheDescriptor(String name, Class<? extends CacheManagement> klass, Long ttl, Map<String, String> options) {
        this.name = name;
        this.klass = klass;
        this.ttl = ttl;
        this.options.putAll(options);
    }

    public String getName() {
        return this.name;
    }

    public long getTTL() {
        return this.ttl == null ? 1L : this.ttl;
    }

    public Class<? extends CacheManagement> getKlass() {
        return this.klass;
    }

    public Map<String, String> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }
}

