/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheDescriptor;
import org.nuxeo.ecm.core.cache.CacheInvalidator;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.ecm.core.cache.CacheMetrics;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.cache.InMemoryCacheImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.cluster.ClusterService;
import org.nuxeo.runtime.model.Component;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.pubsub.AbstractPubSubBroker;
import org.nuxeo.runtime.pubsub.SerializableMessage;

public class CacheServiceImpl
extends DefaultComponent
implements CacheService {
    private static final Logger log = LogManager.getLogger(CacheServiceImpl.class);
    public static final String XP_CACHES = "caches";
    public static final String DEFAULT_CACHE_ID = "default-cache";
    public static final String CACHE_INVAL_PUBSUB_TOPIC = "cacheinval";
    protected static final CacheDescriptor DEFAULT_CACHE_DESCRIPTOR = new CacheDescriptor("default-cache", null, 1L, Map.of("maxSize", String.valueOf(100L)));
    protected boolean started;
    protected final Map<String, CacheManagement> caches = new ConcurrentHashMap<String, CacheManagement>();
    protected final Map<String, CacheDescriptor> programmaticCaches = new ConcurrentHashMap<String, CacheDescriptor>();
    protected CachePubSubInvalidator invalidator;

    @Override
    public void registerCache(String name) {
        if (name == null || this.getCacheDescriptor(name) != null) {
            return;
        }
        CacheDescriptor defaultDescriptor = this.getRegistryContribution(XP_CACHES, DEFAULT_CACHE_ID).orElse(DEFAULT_CACHE_DESCRIPTOR);
        CacheDescriptor descriptor = new CacheDescriptor(name, defaultDescriptor.getKlass(), defaultDescriptor.getTTL(), defaultDescriptor.getOptions());
        this.programmaticCaches.put(name, descriptor);
        this.maybeStart(name, descriptor);
    }

    public int getApplicationStartedOrder() {
        Component component = (Component)Framework.getRuntime().getComponent("org.nuxeo.ecm.core.repository.RepositoryServiceComponent");
        if (component == null) {
            return super.getApplicationStartedOrder();
        }
        return component.getApplicationStartedOrder() - 5;
    }

    public void start(ComponentContext context) {
        super.start(context);
        ClusterService clusterService = (ClusterService)Framework.getService(ClusterService.class);
        if (clusterService.isEnabled()) {
            String nodeId = clusterService.getNodeId();
            this.invalidator = new CachePubSubInvalidator();
            this.invalidator.initialize(CACHE_INVAL_PUBSUB_TOPIC, nodeId);
            log.info("Registered cache invalidator for node: {}", (Object)nodeId);
        } else {
            log.info("Not registering a cache invalidator because clustering is not enabled");
        }
        this.getRegistryContributions(XP_CACHES).stream().filter(c -> !this.programmaticCaches.containsKey(c.getName())).forEach(this::startCacheDescriptor);
        this.programmaticCaches.values().forEach(this::startCacheDescriptor);
        this.started = true;
    }

    protected void startCacheDescriptor(CacheDescriptor desc) {
        CacheManagement cache;
        if (desc.klass == null) {
            cache = new InMemoryCacheImpl(desc);
        } else {
            try {
                cache = desc.klass.getConstructor(CacheDescriptor.class).newInstance(desc);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException("Failed to instantiate class: " + desc.klass + " for cache: " + desc.name, (Throwable)e);
            }
        }
        cache = new CacheAttributesChecker(cache);
        cache = new CacheMetrics(cache);
        if (this.invalidator != null) {
            cache = new CacheInvalidator(cache, this.invalidator);
        }
        cache.start();
        this.caches.put(desc.name, cache);
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        if (this.invalidator != null) {
            this.invalidator.close();
            this.invalidator = null;
        }
        for (CacheManagement cache : this.caches.values()) {
            cache.stop();
        }
        this.caches.clear();
        this.programmaticCaches.clear();
        this.started = false;
    }

    protected void maybeStart(String name, CacheDescriptor descriptor) {
        if (!this.started) {
            return;
        }
        CacheManagement cache = this.caches.get(name);
        if (cache != null) {
            cache.stop();
        }
        this.startCacheDescriptor(descriptor);
    }

    @Override
    public Cache getCache(String name) {
        return this.caches.get(name);
    }

    public CacheDescriptor getCacheDescriptor(String name) {
        CacheDescriptor desc = this.programmaticCaches.get(name);
        if (desc != null) {
            return desc;
        }
        return this.getRegistryContribution(XP_CACHES, name).orElse(null);
    }

    protected class CachePubSubInvalidator
    extends AbstractCachePubSubInvalidator {
        protected CachePubSubInvalidator() {
        }

        @Override
        protected Cache getCache(String name) {
            return CacheServiceImpl.this.getCache(name);
        }
    }

    public static abstract class AbstractCachePubSubInvalidator
    extends AbstractPubSubBroker<CacheInvalidation> {
        public static final String ALL_KEYS = "__ALL__";

        public CacheInvalidation deserialize(InputStream in) throws IOException {
            return CacheInvalidation.deserialize(in);
        }

        public void sendInvalidation(String cacheName, String key) {
            this.sendMessage(new CacheInvalidation(cacheName, key));
        }

        public void sendInvalidationsAll(String cacheName) {
            this.sendMessage(new CacheInvalidation(cacheName, ALL_KEYS));
        }

        public void receivedMessage(CacheInvalidation invalidation) {
            CacheManagement cache = (CacheManagement)this.getCache(invalidation.cacheName);
            if (cache != null) {
                String key = invalidation.key;
                if (ALL_KEYS.equals(key)) {
                    cache.invalidateLocalAll();
                } else {
                    cache.invalidateLocal(key);
                }
            }
        }

        protected abstract Cache getCache(String var1);
    }

    public static class CacheInvalidation
    implements SerializableMessage {
        private static final long serialVersionUID = 1L;
        protected static final String SEP = "/";
        public final String cacheName;
        public final String key;

        public CacheInvalidation(String name, String key) {
            this.cacheName = name;
            this.key = key;
        }

        public void serialize(OutputStream out) throws IOException {
            String string = this.cacheName + SEP + this.key;
            IOUtils.write((String)string, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }

        public static CacheInvalidation deserialize(InputStream in) throws IOException {
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            String[] parts = string.split(SEP, 2);
            if (parts.length != 2) {
                throw new IOException("Invalid invalidation: " + string);
            }
            String cacheName = parts[0];
            String key = parts[1];
            return new CacheInvalidation(cacheName, key);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.cacheName + "," + this.key + ")";
        }
    }
}

