/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.transientstore.SimpleTransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreConfig;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreProvider;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.runtime.RuntimeMessage;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class TransientStorageComponent
extends DefaultComponent
implements TransientStoreService {
    private static final Logger log = LogManager.getLogger(TransientStorageComponent.class);
    protected Map<String, TransientStoreProvider> stores = new HashMap<String, TransientStoreProvider>();
    public static final String EP_STORE = "store";
    public static final String DEFAULT_STORE_NAME = "default";

    @Override
    public synchronized TransientStore getStore(String name) {
        Objects.requireNonNull(name, "Transient store name cannot be null");
        TransientStore store = this.stores.get(name);
        if (store == null) {
            TransientStoreProvider provider;
            TransientStoreConfig descriptor;
            Optional optDescriptor = this.getRegistryContribution(EP_STORE, name);
            if (optDescriptor.isEmpty()) {
                descriptor = new TransientStoreConfig(this.getDefaultDescriptor());
                descriptor.name = name;
            } else {
                descriptor = !DEFAULT_STORE_NAME.equals(name) ? this.getDefaultDescriptor().merge((TransientStoreConfig)optDescriptor.get()) : (TransientStoreConfig)optDescriptor.get();
            }
            try {
                Class<? extends TransientStoreProvider> klass = descriptor.implClass;
                if (klass == null) {
                    klass = SimpleTransientStore.class;
                }
                provider = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                provider.init(descriptor);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            this.stores.put(name, provider);
            store = provider;
        }
        return store;
    }

    protected TransientStoreConfig getDefaultDescriptor() {
        Optional descriptor = this.getRegistryContribution(EP_STORE, DEFAULT_STORE_NAME);
        if (descriptor.isEmpty()) {
            String message = "Missing configuration for default transient store, using in-memory";
            log.warn(message);
            this.addRuntimeMessage(RuntimeMessage.Level.WARNING, message);
            return new TransientStoreConfig(DEFAULT_STORE_NAME);
        }
        return (TransientStoreConfig)descriptor.get();
    }

    @Override
    public void doGC() {
        this.stores.values().forEach(TransientStoreProvider::doGC);
    }

    public void start(ComponentContext context) {
        this.getStore(DEFAULT_STORE_NAME);
        this.getRegistryContributions(EP_STORE).forEach(desc -> this.getStore(desc.getId()));
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.stores.values().forEach(TransientStoreProvider::shutdown);
        super.stop(context);
    }

    public void deactivate(ComponentContext context) {
        this.stores.clear();
        super.deactivate(context);
    }

    public void cleanUpStores() {
        this.stores.values().forEach(TransientStoreProvider::removeAll);
    }
}

