/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.codec;

import java.util.Map;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.codec.AvroRecordCodec;
import org.nuxeo.runtime.codec.CodecFactory;

public class AvroRecordCodecFactory
implements CodecFactory {
    public static final String KEY_SCHEMA_REGISTRY_URLS = "schemaRegistryUrls";
    public static final String DEFAULT_SCHEMA_REGISTRY_URLS = "http://localhost:8081";
    public static final String KEY_MESSAGE_CLASS = "messageClass";
    protected String messageClassName;
    protected String schemaRegistryUrls;

    @Override
    public void init(Map<String, String> options) {
        this.messageClassName = options.get(KEY_MESSAGE_CLASS);
        if (this.messageClassName == null) {
            throw new IllegalArgumentException("AvroRecordCodecFactory requires a messageClass option.");
        }
        this.schemaRegistryUrls = options.getOrDefault(KEY_SCHEMA_REGISTRY_URLS, DEFAULT_SCHEMA_REGISTRY_URLS);
    }

    @Override
    public <T> Codec<T> newCodec(Class<T> objectClass) {
        if (!objectClass.isAssignableFrom(Record.class)) {
            throw new IllegalArgumentException("AvroRecordCodecFactory works only Computation Record not: " + objectClass);
        }
        try {
            return new AvroRecordCodec(this.messageClassName, this.schemaRegistryUrls);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid messageClass: " + this.messageClassName);
        }
    }
}

