/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.RetryPolicy;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.computation.ComputationPolicy;
import org.nuxeo.lib.stream.computation.ComputationPolicyBuilder;
import org.nuxeo.lib.stream.computation.RecordFilter;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.DefaultNuxeoComputationPolicy;
import org.nuxeo.runtime.stream.StreamComputationPolicy;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

@XObject(value="streamProcessor")
@XRegistry(enable=false, compatWarnOnMerge=true)
public class StreamProcessorDescriptor {
    public static String RECOVERY_SKIP_FIRST_FAILURES_OPTION = "nuxeo.stream.recovery.skipFirstFailures";
    @XNode(value="@enable", fallback="@enabled", defaultAssignment="true")
    @XEnable
    protected boolean isEnabled;
    @XNode(value="@start", defaultAssignment="true")
    protected boolean start;
    public static final Integer DEFAULT_CONCURRENCY = 4;
    @XNode(value="@name")
    @XRegistryId
    public String name;
    @XNode(value="@logConfig")
    public String config;
    @XNode(value="@class")
    public Class<? extends StreamProcessorTopology> klass;
    @XNode(value="@defaultConcurrency")
    public Integer defaultConcurrency = DEFAULT_CONCURRENCY;
    @XNode(value="@defaultPartitions")
    public Integer defaultPartitions = DEFAULT_CONCURRENCY;
    @XNode(value="@defaultCodec")
    public String defaultCodec;
    @XNode(value="@defaultExternal")
    public boolean defaultExternal;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();
    @XNodeList(value="computation", type=ArrayList.class, componentType=ComputationDescriptor.class)
    public List<ComputationDescriptor> computations = new ArrayList<ComputationDescriptor>();
    @XNodeList(value="stream", type=ArrayList.class, componentType=StreamDescriptor.class)
    public List<StreamDescriptor> streams = new ArrayList<StreamDescriptor>();
    @XNodeList(value="policy", type=ArrayList.class, componentType=PolicyDescriptor.class)
    public List<PolicyDescriptor> policies = new ArrayList<PolicyDescriptor>();
    protected ComputationPolicy defaultPolicy;

    public ComputationPolicy getPolicy(String computationName) {
        PolicyDescriptor policyDescriptor = this.policies.stream().filter(policy -> computationName.equals(policy.getId())).findFirst().orElse(null);
        if (policyDescriptor != null) {
            return this.getComputationPolicy(policyDescriptor);
        }
        return null;
    }

    protected ComputationPolicy getComputationPolicy(PolicyDescriptor policyDescriptor) {
        if (policyDescriptor.klass != null) {
            if (!StreamComputationPolicy.class.isAssignableFrom(policyDescriptor.klass)) {
                throw new IllegalArgumentException("Cannot create policy: " + policyDescriptor.getId() + " for processor: " + this.getId() + ", class must implement StreamComputationPolicy");
            }
            try {
                return policyDescriptor.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getPolicy(policyDescriptor);
            }
            catch (ReflectiveOperationException e) {
                throw new StreamRuntimeException("Cannot create policy: " + policyDescriptor.getId() + " for processor: " + this.getId(), (Throwable)e);
            }
        }
        return new DefaultNuxeoComputationPolicy().getPolicy(policyDescriptor);
    }

    public ComputationPolicy getDefaultPolicy() {
        if (this.defaultPolicy == null) {
            PolicyDescriptor policyDescriptor = this.policies.stream().filter(policy -> "default".equals(policy.getId())).findFirst().orElse(null);
            this.defaultPolicy = policyDescriptor == null ? ComputationPolicy.NONE : this.getComputationPolicy(policyDescriptor);
        }
        return this.defaultPolicy;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public String getId() {
        return this.name;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    @XObject(value="policy")
    public static class PolicyDescriptor {
        public static final int DEFAULT_MAX_RETRIES = 0;
        public static final Duration DEFAULT_DELAY = Duration.ofSeconds(1L);
        public static final Duration DEFAULT_MAX_DELAY = Duration.ofSeconds(10L);
        public static final Integer DEFAULT_BATCH_CAPACITY = 1;
        public static final Duration DEFAULT_BATCH_THRESHOLD = Duration.ofSeconds(1L);
        @XNode(value="@name")
        public String name;
        @XNode(value="@maxRetries")
        public Integer maxRetries = 0;
        @XNode(value="@delay")
        public Duration delay = DEFAULT_DELAY;
        @XNode(value="@maxDelay")
        public Duration maxDelay = DEFAULT_MAX_DELAY;
        @XNode(value="@continueOnFailure")
        public Boolean continueOnFailure = Boolean.FALSE;
        @XNode(value="@skipFirstFailures")
        public Integer skipFirstFailures = 0;
        @XNode(value="@class")
        public Class<? extends StreamComputationPolicy> klass;
        @XNode(value="@batchCapacity")
        public Integer batchCapacity = DEFAULT_BATCH_CAPACITY;
        @XNode(value="@batchThreshold")
        public Duration batchThreshold = DEFAULT_BATCH_THRESHOLD;

        public String getId() {
            return this.name;
        }

        protected int getSkipFirstFailures() {
            return Integer.parseInt(Framework.getProperty((String)RECOVERY_SKIP_FIRST_FAILURES_OPTION, (String)Integer.toString(this.skipFirstFailures)));
        }

        public ComputationPolicyBuilder createPolicyBuilder() {
            RetryPolicy retryPolicy = new RetryPolicy().withMaxRetries(this.maxRetries.intValue()).withBackoff(this.delay.toMillis(), this.maxDelay.toMillis(), TimeUnit.MILLISECONDS);
            return new ComputationPolicyBuilder().retryPolicy(retryPolicy).batchPolicy(this.batchCapacity.intValue(), this.batchThreshold).continueOnFailure(this.continueOnFailure.booleanValue()).skipFirstFailures(this.getSkipFirstFailures());
        }
    }

    @XObject(value="stream")
    public static class StreamDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@partitions")
        public Integer partitions;
        @XNode(value="@codec")
        public String codec;
        @XNode(value="@external")
        public Boolean external;
        @XNodeList(value="filter", type=ArrayList.class, componentType=FilterDescriptor.class)
        public List<FilterDescriptor> filters = new ArrayList<FilterDescriptor>();

        public String getId() {
            return this.name;
        }
    }

    @XObject(value="filter")
    public static class FilterDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@class")
        public Class<? extends RecordFilter> klass;
        @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
        public Map<String, String> options = new HashMap<String, String>();

        public String getId() {
            return this.name;
        }

        public RecordFilter getFilter() {
            if (!RecordFilter.class.isAssignableFrom(this.klass)) {
                throw new IllegalArgumentException("Cannot create filter: " + this.getId() + " for stream: " + this.getId() + ", class must implement Filter");
            }
            try {
                RecordFilter ret = this.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ret.init(this.options);
                return ret;
            }
            catch (ReflectiveOperationException e) {
                throw new StreamRuntimeException("Cannot create filter: " + this.getId(), (Throwable)e);
            }
        }
    }

    @XObject(value="computation")
    public static class ComputationDescriptor {
        @XNode(value="@name")
        public String name;
        @XNode(value="@concurrency")
        public Integer concurrency = DEFAULT_CONCURRENCY;

        public String getId() {
            return this.name;
        }
    }
}

