/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.stream;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.lib.stream.StreamRuntimeException;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.computation.Settings;
import org.nuxeo.lib.stream.computation.StreamManager;
import org.nuxeo.lib.stream.computation.StreamProcessor;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.lib.stream.computation.log.LogStreamManager;
import org.nuxeo.lib.stream.log.LogConfig;
import org.nuxeo.lib.stream.log.Name;
import org.nuxeo.lib.stream.log.UnifiedLogManager;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogConfig;
import org.nuxeo.lib.stream.log.kafka.KafkaLogConfig;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.codec.CodecService;
import org.nuxeo.runtime.kafka.KafkaConfigService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.stream.LogConfigDescriptor;
import org.nuxeo.runtime.stream.StreamProcessorDescriptor;
import org.nuxeo.runtime.stream.StreamService;

public class StreamServiceImpl
extends DefaultComponent
implements StreamService,
ComponentManager.Listener {
    private static final Logger log = LogManager.getLogger(StreamServiceImpl.class);
    public static final String NUXEO_STREAM_DIR_PROP = "nuxeo.stream.chronicle.dir";
    public static final String NUXEO_STREAM_RET_DURATION_PROP = "nuxeo.stream.chronicle.retention.duration";
    public static final String DEFAULT_CODEC = "avro";
    protected static final String XP_LOG_CONFIG = "logConfig";
    protected static final String XP_STREAM_PROCESSOR = "streamProcessor";
    protected org.nuxeo.lib.stream.log.LogManager logManager;
    protected StreamManager streamManager;
    protected final Map<String, StreamProcessor> processors = new HashMap<String, StreamProcessor>();
    public static final String STREAM_PROCESSING_ENABLED = "nuxeo.stream.processing.enabled";
    protected Boolean isStreamProcessingDisabled;

    public int getApplicationStartedOrder() {
        return -590;
    }

    @Override
    public org.nuxeo.lib.stream.log.LogManager getLogManager() {
        return this.logManager;
    }

    @Override
    public StreamManager getStreamManager() {
        return this.streamManager;
    }

    protected String getChronicleRetention(String retention) {
        return retention != null ? retention : Framework.getProperty((String)NUXEO_STREAM_RET_DURATION_PROP, (String)"4d");
    }

    protected Path getChroniclePath(String basePath) {
        if (basePath != null) {
            return Paths.get(basePath, new String[0]).toAbsolutePath();
        }
        basePath = Framework.getProperty((String)NUXEO_STREAM_DIR_PROP);
        if (basePath != null) {
            return Paths.get(basePath, new String[0]).toAbsolutePath();
        }
        basePath = Framework.getProperty((String)"nuxeo.data.dir");
        if (basePath != null) {
            return Paths.get(basePath, "stream").toAbsolutePath();
        }
        return Paths.get(Framework.getRuntime().getHome().getAbsolutePath(), "data", "stream").toAbsolutePath();
    }

    protected void createLogIfNotExists(LogConfigDescriptor config) {
        if (!config.isEnabled() || config.logs.isEmpty()) {
            return;
        }
        config.logs.forEach(l -> {
            log.info("Create if not exists stream: {} with manager: {}", (Object)l.getId(), (Object)config.getId());
            this.logManager.createIfNotExists(Name.ofUrn((String)l.getId()), l.size.intValue());
        });
    }

    public void start(ComponentContext context) {
        super.start(context);
        List<LogConfig> configs = this.getLogConfigs();
        this.logManager = new UnifiedLogManager(configs);
        this.streamManager = new LogStreamManager(this.logManager);
        List logDescs = this.getRegistryContributions(XP_LOG_CONFIG);
        logDescs.forEach(this::createLogIfNotExists);
        List streamDescs = this.getRegistryContributions(XP_STREAM_PROCESSOR);
        streamDescs.forEach(this::initProcessor);
    }

    protected List<LogConfig> getLogConfigs() {
        List logDescs = this.getRegistryContributions(XP_LOG_CONFIG);
        ArrayList<LogConfig> ret = new ArrayList<LogConfig>(logDescs.size());
        for (LogConfigDescriptor desc : logDescs) {
            if (!desc.isEnabled() || desc.onlyLogDeclaration()) continue;
            if ("kafka".equalsIgnoreCase(desc.type)) {
                ret.add(this.createKafkaLogConfig(desc));
                continue;
            }
            ret.add(this.createChronicleLogConfig(desc));
        }
        return ret;
    }

    protected LogConfig createKafkaLogConfig(LogConfigDescriptor desc) {
        String kafkaConfig = desc.options.getOrDefault("kafkaConfig", "default");
        KafkaConfigService service = (KafkaConfigService)Framework.getService(KafkaConfigService.class);
        return new KafkaLogConfig(desc.getId(), desc.isDefault(), desc.getPatterns(), service.getTopicPrefix(kafkaConfig), service.getAdminProperties(kafkaConfig), service.getProducerProperties(kafkaConfig), service.getConsumerProperties(kafkaConfig));
    }

    protected LogConfig createChronicleLogConfig(LogConfigDescriptor desc) {
        String basePath = desc.options.getOrDefault("basePath", null);
        Path path = this.getChroniclePath(basePath);
        String retention = this.getChronicleRetention(desc.options.getOrDefault("retention", null));
        return new ChronicleLogConfig(desc.getId(), desc.isDefault(), desc.getPatterns(), path, retention);
    }

    protected void initProcessor(StreamProcessorDescriptor descriptor) {
        Topology topology;
        if (!descriptor.isEnabled()) {
            log.info("Processor {} disabled", (Object)descriptor.getId());
            return;
        }
        if (this.processors.containsKey(descriptor.getId())) {
            log.error("Processor already initialized: {}", (Object)descriptor.getId());
            return;
        }
        log.info("Init Stream processor: {}", (Object)descriptor.getId());
        try {
            topology = descriptor.klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getTopology(descriptor.options);
        }
        catch (ReflectiveOperationException e) {
            throw new StreamRuntimeException("Can not create topology for processor: " + descriptor.getId(), (Throwable)e);
        }
        Settings settings = this.getSettings(descriptor);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = descriptor::getId;
        supplierArray[1] = () -> topology.toPlantuml(settings);
        log.debug("Starting computation topology: {}\n{}", supplierArray);
        if (!this.isProcessingDisabled() && descriptor.isStart()) {
            StreamProcessor streamProcessor = this.streamManager.registerAndCreateProcessor(descriptor.getId(), topology, settings);
            this.processors.put(descriptor.getId(), streamProcessor);
        } else {
            this.streamManager.register(descriptor.getId(), topology, settings);
            this.processors.put(descriptor.getId(), null);
        }
    }

    protected Settings getSettings(StreamProcessorDescriptor descriptor) {
        CodecService codecService = (CodecService)Framework.getService(CodecService.class);
        Codec<Record> actualCodec = descriptor.defaultCodec == null ? codecService.getCodec(DEFAULT_CODEC, Record.class) : codecService.getCodec(descriptor.defaultCodec, Record.class);
        Settings settings = new Settings(descriptor.defaultConcurrency.intValue(), descriptor.defaultPartitions.intValue(), actualCodec, descriptor.getDefaultPolicy(), null, descriptor.defaultExternal);
        descriptor.computations.forEach(comp -> settings.setConcurrency(comp.name, comp.concurrency.intValue()));
        descriptor.policies.forEach(policy -> settings.setPolicy(policy.name, descriptor.getPolicy(policy.name)));
        for (StreamProcessorDescriptor.StreamDescriptor streamDescriptor : descriptor.streams) {
            settings.setPartitions(streamDescriptor.name, (streamDescriptor.partitions != null ? streamDescriptor.partitions : descriptor.defaultPartitions).intValue());
            if (streamDescriptor.codec != null) {
                settings.setCodec(streamDescriptor.name, codecService.getCodec(streamDescriptor.codec, Record.class));
            }
            streamDescriptor.filters.forEach(filter -> settings.addFilter(streamDescriptor.name, filter.getFilter()));
            settings.setExternal(Name.ofUrn((String)streamDescriptor.name), streamDescriptor.external != null ? streamDescriptor.external : descriptor.defaultExternal);
        }
        return settings;
    }

    public void stop(ComponentContext context) throws InterruptedException {
        super.stop(context);
        this.logManager.close();
    }

    protected void startProcessors() {
        log.debug("Start processors");
        this.getRegistryContributions(XP_STREAM_PROCESSOR).forEach(d -> {
            StreamProcessor processor = this.processors.get(((StreamProcessorDescriptor)d).getId());
            if (processor != null) {
                processor.start();
            }
        });
    }

    @Override
    public void stopProcessors() {
        log.debug("Stop processors");
        this.processors.forEach((name, processor) -> {
            if (processor != null) {
                processor.stop(Duration.ofSeconds(1L));
            }
        });
        this.processors.clear();
    }

    public void afterRuntimeStart(ComponentManager mgr, boolean isResume) {
        log.debug("afterRuntimeStart");
        this.startProcessors();
    }

    public void beforeRuntimeStop(ComponentManager mgr, boolean isStandby) {
        log.debug("beforeRuntimeStop");
        this.stopProcessors();
    }

    protected boolean isProcessingDisabled() {
        if (this.isStreamProcessingDisabled == null) {
            if (Framework.isBooleanPropertyFalse((String)STREAM_PROCESSING_ENABLED)) {
                log.warn("Stream Processing has been disabled on this node");
                this.isStreamProcessingDisabled = true;
            } else {
                this.isStreamProcessingDisabled = false;
            }
        }
        return this.isStreamProcessingDisabled;
    }
}

