/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.jwt;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.jwt.JWTService;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.ui.web.auth.interfaces.NuxeoAuthenticationPlugin;
import org.nuxeo.runtime.api.Framework;

public class JWTAuthenticator
implements NuxeoAuthenticationPlugin {
    private static final Log log = LogFactory.getLog(JWTAuthenticator.class);
    protected static final String BEARER_SP = "Bearer ";
    protected static final String ACCESS_TOKEN = "access_token";

    public void initPlugin(Map<String, String> parameters) {
    }

    public List<String> getUnAuthenticatedURLPrefix() {
        return null;
    }

    public Boolean needLoginPrompt(HttpServletRequest httpRequest) {
        return Boolean.FALSE;
    }

    public Boolean handleLoginPrompt(HttpServletRequest httpRequest, HttpServletResponse httpResponse, String baseURL) {
        return Boolean.FALSE;
    }

    public UserIdentificationInfo handleRetrieveIdentity(HttpServletRequest request, HttpServletResponse response) {
        Object aud;
        String token = this.retrieveToken(request);
        if (token == null) {
            log.trace((Object)"No JWT token");
            return null;
        }
        JWTService service = (JWTService)Framework.getService(JWTService.class);
        Map<String, Object> claims = service.verifyToken(token);
        if (claims == null) {
            log.trace((Object)"JWT token invalid");
            return null;
        }
        Object sub = claims.get("sub");
        if (!(sub instanceof String)) {
            log.trace((Object)"JWT token contains non-String subject claim");
            return null;
        }
        String username = (String)sub;
        if (log.isTraceEnabled()) {
            log.trace((Object)("JWT token valid for username: " + username));
        }
        if ((aud = claims.get("aud")) != null) {
            if (!(aud instanceof String)) {
                log.trace((Object)"JWT token contains non-String audience claim");
                return null;
            }
            String audience = StringUtils.strip((String)((String)aud), (String)"/");
            String path = JWTAuthenticator.getRequestPath(request);
            if (!JWTAuthenticator.isEqualOrPathPrefix(path, audience)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("JWT token for audience: " + audience + " but used with path: " + path));
                }
                return null;
            }
        }
        return new UserIdentificationInfo(username);
    }

    protected String retrieveToken(HttpServletRequest request) {
        String auth = request.getHeader("Authorization");
        if (auth == null) {
            String token = request.getParameter(ACCESS_TOKEN);
            if (StringUtils.isNotEmpty((CharSequence)token)) {
                log.trace((Object)"Access token available from URI");
                return token;
            }
            log.trace((Object)"No Authorization header or URI access token");
        } else if (auth.startsWith(BEARER_SP)) {
            String token = auth.substring(BEARER_SP.length()).trim();
            if (!token.isEmpty()) {
                log.trace((Object)"Bearer token available");
                return token;
            }
            log.trace((Object)"Bearer token empty");
        } else {
            log.trace((Object)"Authorization header without Bearer token");
        }
        return null;
    }

    protected static String getRequestPath(HttpServletRequest request) {
        Object path = request.getServletPath();
        String info = request.getPathInfo();
        if (info != null) {
            path = (String)path + info;
        }
        if (!((String)path).isEmpty()) {
            path = ((String)path).substring(1);
        }
        return path;
    }

    protected static boolean isEqualOrPathPrefix(String path, String prefix) {
        return path.equals(prefix) || path.startsWith(prefix + "/");
    }
}

