/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.client.ESRestClientFactory;
import org.nuxeo.elasticsearch.config.ElasticSearchClientConfig;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationHolder;
import org.nuxeo.launcher.config.backingservices.BackingChecker;

public class ElasticSearchChecker
implements BackingChecker {
    private static final Logger log = LogManager.getLogger(ElasticSearchChecker.class);
    protected static final String ELASTIC_ENABLED_PROP = "elasticsearch.enabled";
    protected static final String ELASTIC_REST_CLIENT_PROP = "elasticsearch.client";
    protected static final String ADDRESS_LIST_OPT = "addressList";
    protected static final String CONFIG_NAME = "elasticsearch-config.xml";

    public boolean accepts(ConfigurationHolder configHolder) {
        if (!"true".equals(configHolder.getProperty(ELASTIC_ENABLED_PROP))) {
            log.debug("Checker skipped because elasticsearch is disabled");
            return false;
        }
        if (!"RestClient".equals(configHolder.getProperty(ELASTIC_REST_CLIENT_PROP))) {
            log.debug("Checker skipped because not using a rest client");
            return false;
        }
        log.debug("Checker accepted");
        return true;
    }

    public void check(ConfigurationHolder configHolder) throws ConfigurationException {
        ElasticSearchClientConfig config = (ElasticSearchClientConfig)this.getDescriptor(configHolder, CONFIG_NAME, ElasticSearchClientConfig.class, content -> content.replace("class=", "ignore="));
        String addressList = config.getOption(ADDRESS_LIST_OPT);
        if (addressList == null || addressList.isEmpty()) {
            log.debug("Elasticsearch config check skipped on embedded configuration");
            return;
        }
        log.debug("Check elastic config: {}", (Object)config);
        ClusterHealthStatus status = this.getHealthStatus(config);
        switch (status) {
            case GREEN: 
            case YELLOW: {
                log.debug("Check is ok, cluster health is {}", (Object)status);
                return;
            }
        }
        throw new ConfigurationException("Elasticsearch cluster is not healthy: " + status);
    }

    protected ClusterHealthStatus getHealthStatus(ElasticSearchClientConfig config) throws ConfigurationException {
        ClusterHealthStatus clusterHealthStatus;
        block8: {
            ESClient client = this.getClient(config);
            try {
                clusterHealthStatus = client.getHealthStatus(null);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ConfigurationException("Unable to connect to Elasticsearch: " + config.getOption(ADDRESS_LIST_OPT), (Throwable)e);
                }
            }
            client.close();
        }
        return clusterHealthStatus;
    }

    protected ESClient getClient(ElasticSearchClientConfig config) {
        ESRestClientFactory clientFactory = new ESRestClientFactory();
        return clientFactory.create(null, config);
    }
}

