/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import java.time.ZonedDateTime;

public final class DateHelper {
    private DateHelper() {
    }

    public static ZonedDateTime plusDuration(ZonedDateTime origin, String duration) {
        if (duration.matches("[a-zA-Z]+")) {
            return DateHelper.plusDurationAsNoun(origin, duration);
        }
        if (duration.matches("[0-9]+")) {
            return origin.plusNanos(Integer.valueOf(duration) * 1000);
        }
        return DateHelper.plusDurationAsExpression(origin, duration);
    }

    private static ZonedDateTime plusDurationAsExpression(ZonedDateTime origin, String duration) {
        int k = DateHelper.getFactor(duration);
        switch (duration.substring(duration.length() - 1, duration.length())) {
            case "s": {
                return origin.plusSeconds(k);
            }
            case "m": {
                return origin.plusMinutes(k);
            }
            case "h": {
                return origin.plusHours(k);
            }
            case "d": {
                return origin.plusDays(k);
            }
            case "w": {
                return origin.plusWeeks(k);
            }
            case "M": {
                return origin.plusMonths(k);
            }
            case "y": {
                return origin.plusYears(k);
            }
        }
        return DateHelper.invalid(duration);
    }

    private static int getFactor(String duration) {
        try {
            return Integer.valueOf(duration.substring(0, duration.length() - 1));
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException e) {
            DateHelper.invalid(duration);
            return 1;
        }
    }

    private static ZonedDateTime plusDurationAsNoun(ZonedDateTime origin, String duration) {
        switch (duration.toLowerCase()) {
            case "second": {
                return origin.plusSeconds(1L);
            }
            case "minute": {
                return origin.plusMinutes(1L);
            }
            case "hour": {
                return origin.plusHours(1L);
            }
            case "day": {
                return origin.plusDays(1L);
            }
            case "week": {
                return origin.plusWeeks(1L);
            }
            case "month": {
                return origin.plusMonths(1L);
            }
            case "quarter": {
                return origin.plusMonths(3L);
            }
            case "year": {
                return origin.plusYears(1L);
            }
        }
        return DateHelper.invalid(duration);
    }

    private static ZonedDateTime invalid(String msg) {
        throw new IllegalArgumentException("Invalid duration: " + msg);
    }
}

