/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collection;
import java.util.Collections;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketTerm;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;

public class SingleValueMetricAggregate
extends AggregateEsBase<NumericMetricsAggregation.SingleValue, BucketTerm> {
    protected final AggregationBuilder aggregationBuilder;
    protected Double value;

    public SingleValueMetricAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
        this.aggregationBuilder = this.toBuilder(definition.getType());
    }

    public AggregationBuilder toBuilder(String type) {
        switch (type) {
            case "cardinality": {
                return AggregationBuilders.cardinality((String)this.getId()).field(this.getField());
            }
            case "count": {
                return AggregationBuilders.count((String)this.getId()).field(this.getField());
            }
            case "sum": {
                return AggregationBuilders.sum((String)this.getId()).field(this.getField());
            }
            case "avg": {
                return AggregationBuilders.avg((String)this.getId()).field(this.getField());
            }
            case "max": {
                return AggregationBuilders.max((String)this.getId()).field(this.getField());
            }
            case "min": {
                return AggregationBuilders.min((String)this.getId()).field(this.getField());
            }
        }
        throw new IllegalArgumentException("Unknown aggregate type: " + type);
    }

    @Override
    @JsonIgnore
    public AggregationBuilder getEsAggregate() {
        return this.aggregationBuilder;
    }

    @Override
    @JsonIgnore
    public QueryBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        return QueryBuilders.termsQuery((String)this.getField(), (Collection)this.getSelection());
    }

    @Override
    public void parseAggregation(NumericMetricsAggregation.SingleValue aggregation) {
        this.value = aggregation.value();
        this.buckets = Collections.singletonList(new BucketTerm(this.definition.getType(), this.value.longValue()));
    }

    public Double getValue() {
        return this.value;
    }
}

