/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.api;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.elasticsearch.search.SearchHit;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsScrollResult;
import org.nuxeo.elasticsearch.core.EsSearchHitConverter;

public class EsIterableQueryResultImpl
implements IterableQueryResult,
Iterator<Map<String, Serializable>> {
    private final ElasticSearchService searchService;
    private final EsSearchHitConverter converter;
    private final long size;
    private EsScrollResult scrollResult;
    private boolean closed;
    private long pos;
    private int relativePos;

    public EsIterableQueryResultImpl(ElasticSearchService searchService, EsScrollResult scrollResult) {
        assert (!scrollResult.getQueryBuilder().getSelectFieldsAndTypes().isEmpty());
        this.searchService = searchService;
        this.scrollResult = scrollResult;
        this.converter = new EsSearchHitConverter(scrollResult.getQueryBuilder().getSelectFieldsAndTypes());
        this.size = scrollResult.getElasticsearchResponse().getHits().getTotalHits().value;
    }

    public void close() {
        if (!this.closed) {
            this.searchService.clearScroll(this.scrollResult);
            this.closed = true;
            this.pos = -1L;
        }
    }

    public boolean isLife() {
        return this.mustBeClosed();
    }

    public boolean mustBeClosed() {
        return true;
    }

    public long size() {
        return this.size;
    }

    public long pos() {
        return this.pos;
    }

    public void skipTo(long pos) {
        this.checkNotClosed();
        if (pos < this.pos) {
            throw new IllegalArgumentException("Cannot go back in Iterable.");
        }
        if (pos > this.size) {
            pos = this.size;
        } else {
            while (pos > this.pos) {
                this.nextHit();
            }
        }
        this.pos = pos;
    }

    public Iterator<Map<String, Serializable>> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkNotClosed();
        return this.pos < this.size;
    }

    @Override
    public Map<String, Serializable> next() {
        this.checkNotClosed();
        if (this.pos == this.size) {
            throw new NoSuchElementException();
        }
        SearchHit hit = this.nextHit();
        return this.converter.convert(hit);
    }

    private SearchHit nextHit() {
        if (this.relativePos == this.scrollResult.getElasticsearchResponse().getHits().getHits().length) {
            this.scrollResult = this.searchService.scroll(this.scrollResult);
            this.relativePos = 0;
        }
        SearchHit hit = this.scrollResult.getElasticsearchResponse().getHits().getAt(this.relativePos);
        ++this.relativePos;
        ++this.pos;
        return hit;
    }

    private void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Query results iterator closed.");
        }
    }
}

