/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.bulk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.ecm.core.bulk.message.DataBucket;
import org.nuxeo.elasticsearch.api.ESClient;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class BulkIndexComputation
extends AbstractComputation
implements BulkProcessor.Listener {
    private static final Log log = LogFactory.getLog(BulkIndexComputation.class);
    public static final String NAME = "bulk/bulkIndex";
    protected final int esBulkSize;
    protected final int esBulkActions;
    protected final int flushIntervalMs;
    protected BulkProcessor bulkProcessor;
    protected Codec<DataBucket> codec;
    protected boolean updates;
    protected boolean continueOnFailure;
    protected volatile boolean abort;

    public BulkIndexComputation(int esBulkSize, int esBulkActions, int flushInterval) {
        super(NAME, 1, 1);
        this.esBulkSize = esBulkSize;
        this.esBulkActions = esBulkActions;
        this.flushIntervalMs = flushInterval * 1000;
    }

    public void init(ComputationContext context) {
        super.init(context);
        this.continueOnFailure = context.getPolicy().continueOnFailure();
        long backoffDelayMs = context.getPolicy().getRetryPolicy().getDelay().toMillis();
        int retries = context.getPolicy().getRetryPolicy().getMaxRetries();
        this.bulkProcessor = this.getESClient().bulkProcessorBuilder(this).setConcurrentRequests(0).setBulkSize(new ByteSizeValue((long)this.esBulkSize, ByteSizeUnit.BYTES)).setBulkActions(this.esBulkActions).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)backoffDelayMs), (int)retries)).build();
        this.codec = BulkCodecs.getDataBucketCodec();
        context.setTimer("flush", System.currentTimeMillis() + (long)this.flushIntervalMs);
    }

    public void processTimer(ComputationContext context, String key, long timestamp) {
        if (this.abort) {
            throw new NuxeoException("Terminate computation due to previous error");
        }
        if (this.updates) {
            this.bulkProcessor.flush();
            context.askForCheckpoint();
            this.updates = false;
        }
        context.setTimer("flush", System.currentTimeMillis() + (long)this.flushIntervalMs);
    }

    public void processRecord(ComputationContext context, String inputStream, Record record) {
        if (this.abort) {
            return;
        }
        DataBucket in = (DataBucket)this.codec.decode(record.getData());
        if (in.getCount() > 0L) {
            BulkRequest bulkRequest = this.decodeRequest(in);
            for (DocWriteRequest request : bulkRequest.requests()) {
                this.bulkProcessor.add(request);
            }
            BulkStatus delta = BulkStatus.deltaOf((String)in.getCommandId());
            delta.setProcessed(in.getCount());
            AbstractBulkComputation.updateStatus((ComputationContext)context, (BulkStatus)delta);
        }
        this.updates = true;
    }

    public void destroy() {
        if (this.bulkProcessor != null) {
            this.bulkProcessor.close();
            this.bulkProcessor = null;
        }
    }

    protected ESClient getESClient() {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        return esa.getClient();
    }

    protected BulkRequest decodeRequest(DataBucket bucket) {
        BulkRequest bulkRequest;
        ByteBuffer buffer = ByteBuffer.wrap(bucket.getData());
        ByteBufferStreamInput in = new ByteBufferStreamInput(buffer);
        try {
            bulkRequest = new BulkRequest((StreamInput)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new NuxeoException("Cannot load elastic bulk request from: " + bucket);
            }
        }
        in.close();
        return bulkRequest;
    }

    public void beforeBulk(long executionId, BulkRequest request) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Creating elasticsearch bulk %s with %d action", executionId, request.numberOfActions()));
        }
    }

    public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("After bulk: %s, actions: %d, status: %s", executionId, request.numberOfActions(), response.status()));
        }
        if (!response.hasFailures()) {
            return;
        }
        MutableBoolean inError = new MutableBoolean(false);
        Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).forEach(item -> {
            if (item.getFailure().getStatus() != RestStatus.CONFLICT) {
                log.warn((Object)("Failure in bulk indexing: " + item.getFailureMessage()));
                inError.setTrue();
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping version conflict: " + item.getFailureMessage()));
            }
        });
        if (inError.isTrue()) {
            log.error((Object)String.format("Elasticsearch bulk %s returns with failures: %s", executionId, response.buildFailureMessage()));
            if (!this.continueOnFailure) {
                this.abort = true;
            }
        }
    }

    public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
        log.error((Object)String.format("Elasticsearch bulk %s fails, contains %d actions", executionId, request.numberOfActions()), failure);
        if (!this.continueOnFailure) {
            this.abort = true;
        }
    }
}

