/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.bulk;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;

public class IndexCompletionComputation
extends AbstractComputation {
    private static final Logger log = LogManager.getLogger(IndexCompletionComputation.class);
    public static final String NAME = "bulk/indexCompletion";
    protected Codec<BulkStatus> codec;

    public IndexCompletionComputation() {
        super(NAME, 1, 0);
    }

    public void init(ComputationContext context) {
        super.init(context);
        this.codec = BulkCodecs.getStatusCodec();
    }

    public void processRecord(ComputationContext context, String inputStream, Record record) {
        BulkStatus status = (BulkStatus)this.codec.decode(record.getData());
        if ("index".equals(status.getAction()) && BulkStatus.State.COMPLETED.equals((Object)status.getState())) {
            this.logIndexing(status);
            BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
            BulkCommand command = bulkService.getCommand(status.getId());
            if (command != null) {
                this.refreshIndexIfNeeded(command);
                this.updateAliasIfNeeded(command);
            } else {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = () -> ((BulkStatus)status).getId();
                log.error("Command not found for id: {}", supplierArray);
            }
        }
        context.askForCheckpoint();
    }

    protected void refreshIndexIfNeeded(BulkCommand command) {
        Boolean refresh = (Boolean)command.getParam("refresh");
        if (Boolean.TRUE.equals(refresh)) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((BulkCommand)command).getId();
            log.warn("Refresh index requested by command: {}", supplierArray);
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
            esa.refreshRepositoryIndex(command.getRepository());
        }
    }

    protected void updateAliasIfNeeded(BulkCommand command) {
        Boolean updateAlias = (Boolean)command.getParam("updateAlias");
        if (Boolean.TRUE.equals(updateAlias)) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((BulkCommand)command).getId();
            log.warn("Update alias requested by command: {}", supplierArray);
            ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
            esa.syncSearchAndWriteAlias(esa.getIndexNameForRepository(command.getRepository()));
        }
    }

    protected void logIndexing(BulkStatus status) {
        long elapsed = status.getCompletedTime().toEpochMilli() - status.getSubmitTime().toEpochMilli();
        long wait = status.getScrollStartTime().toEpochMilli() - status.getSubmitTime().toEpochMilli();
        long scroll = status.getScrollEndTime().toEpochMilli() - status.getScrollStartTime().toEpochMilli();
        double rate = 1000.0 * (double)status.getTotal() / (double)elapsed;
        log.warn("Index command: {} completed: {} in {}", (Object)status.getId(), (Object)status.getTotal(), (Object)String.format("%.2fs (wait: %.2fs, scroll: %.2fs) rate: %.2f docs/s", (double)elapsed / 1000.0, (double)wait / 1000.0, (double)scroll / 1000.0, rate));
    }
}

