/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XEnable;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.elasticsearch.core.IncrementalIndexNameGenerator;

@XObject(value="elasticSearchIndex")
@XRegistry(enable=false)
public class ElasticSearchIndexConfig {
    public static final String DEFAULT_SETTING_FILE = "default-doc-settings.json";
    public static final String DEFAULT_MAPPING_FILE = "default-doc-mapping.json";
    protected static final String DEFAULT_REPOSITORY_NAME = "default";
    protected static final String WRITE_SUFFIX = "-write";
    @XNode(value="@enable", fallback="@enabled")
    @XEnable
    protected boolean isEnabled = true;
    @XNode(value="@name")
    @XRegistryId
    protected String name;
    @XNode(value="@manageAlias")
    protected boolean manageAlias;
    @XNode(value="@writeAlias")
    protected String writeAlias;
    @XNode(value="@repository")
    protected String repositoryName;
    @XNode(value="@type")
    protected String type = "doc";
    @XNode(value="@create")
    protected boolean create = true;
    @XNode(value="settings")
    protected String settings;
    @XNode(value="settings@file")
    protected String settingsFile;
    @XNode(value="mapping")
    protected String mapping;
    @XNode(value="mapping@file")
    protected String mappingFile;
    @XNodeList(value="fetchFromSource/exclude", type=String[].class, componentType=String.class)
    protected String[] excludes;
    @XNodeList(value="fetchFromSource/include", type=String[].class, componentType=String.class)
    protected String[] includes;

    public String toString() {
        if (this.isEnabled()) {
            return String.format("EsIndexConfig(%s, %s, %s)", this.getName(), this.getRepositoryName(), this.getType());
        }
        return "EsIndexConfig disabled";
    }

    public String[] getExcludes() {
        if (this.excludes == null) {
            return new String[]{"ecm:binarytext"};
        }
        return this.excludes;
    }

    public String[] getIncludes() {
        if (this.includes == null || this.includes.length == 0) {
            return new String[]{"*"};
        }
        return this.includes;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSettings() {
        if (this.settingsFile != null) {
            return this.contentOfFile(this.settingsFile);
        }
        if (this.settings != null && !this.settings.isEmpty()) {
            return this.settings;
        }
        return this.contentOfFile(DEFAULT_SETTING_FILE);
    }

    protected String contentOfFile(String filename) {
        String string;
        block8: {
            InputStream stream = this.getResourceStream(filename);
            try {
                string = IOUtils.toString((InputStream)stream, (String)"UTF-8");
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Cannot load resource file: " + filename, e);
                }
            }
            stream.close();
        }
        return string;
    }

    protected InputStream getResourceStream(String filename) {
        InputStream ret;
        File file = new File(Environment.getDefault().getConfig(), filename);
        if (file.exists()) {
            try {
                return new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if ((ret = this.getClass().getClassLoader().getResourceAsStream(filename)) == null) {
            ret = this.getClass().getClassLoader().getResourceAsStream(filename);
        }
        if (ret == null) {
            throw new IllegalArgumentException(String.format("Resource file cannot be found: %s or %s", file.getAbsolutePath(), filename));
        }
        return ret;
    }

    public String getMapping() {
        if (this.mappingFile != null) {
            return this.contentOfFile(this.mappingFile);
        }
        if (this.mapping != null && !this.mapping.isEmpty()) {
            return this.mapping;
        }
        return this.contentOfFile(DEFAULT_MAPPING_FILE);
    }

    public boolean mustCreate() {
        return this.create;
    }

    public String getRepositoryName() {
        if (this.isDocumentIndex() && this.repositoryName == null) {
            this.repositoryName = DEFAULT_REPOSITORY_NAME;
        }
        return this.repositoryName;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isDocumentIndex() {
        return "doc".equals(this.getType());
    }

    public boolean hasExplicitWriteIndex() {
        return StringUtils.isNotBlank((CharSequence)this.writeAlias);
    }

    public String writeIndexOrAlias() {
        if (this.hasExplicitWriteIndex()) {
            return this.writeAlias;
        }
        if (this.manageAlias) {
            return this.name + WRITE_SUFFIX;
        }
        return this.name;
    }

    public boolean manageAlias() {
        return this.manageAlias;
    }

    public String newWriteIndexForAlias(String aliasName, String oldIndexName) {
        return new IncrementalIndexNameGenerator().getNextIndexName(aliasName, oldIndexName);
    }
}

