/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.io.marshallers.json;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.ZonedDateTime;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.DateUtils;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.api.model.impl.PropertyFactory;
import org.nuxeo.ecm.core.io.marshallers.json.ExtensibleEntityJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.ListTypeImpl;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.SchemaImpl;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.core.BucketRange;
import org.nuxeo.ecm.platform.query.core.BucketRangeDate;
import org.nuxeo.elasticsearch.aggregate.SignificantTermAggregate;
import org.nuxeo.elasticsearch.aggregate.SingleBucketAggregate;
import org.nuxeo.elasticsearch.aggregate.SingleValueMetricAggregate;
import org.nuxeo.elasticsearch.aggregate.TermAggregate;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class AggregateJsonWriter
extends ExtensibleEntityJsonWriter<Aggregate> {
    public static final String ENTITY_TYPE = "aggregate";
    public static final String FETCH_KEY = "key";
    private static final Logger log = LogManager.getLogger(AggregateJsonWriter.class);
    protected static final Schema SYSTEM_SCHEMA = new SchemaImpl("system", null);
    @Inject
    private SchemaManager schemaManager;

    protected Field getSystemField(String name) {
        Field result = SYSTEM_SCHEMA.getField(name);
        if (result == null && name.startsWith("ecm:path@level")) {
            SYSTEM_SCHEMA.addField(name, (org.nuxeo.ecm.core.schema.types.Type)StringType.INSTANCE, null, 0, null);
            return SYSTEM_SCHEMA.getField(name);
        }
        return result;
    }

    public AggregateJsonWriter() {
        super(ENTITY_TYPE, Aggregate.class);
    }

    public AggregateJsonWriter(String entityType, Class<Aggregate> entityClass) {
        super(entityType, entityClass);
    }

    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return true;
    }

    protected void writeEntityBody(Aggregate agg, JsonGenerator jg) throws IOException {
        Field field;
        boolean fetch = this.ctx.getFetched(ENTITY_TYPE).contains(FETCH_KEY);
        String fieldName = agg.getField();
        if (fieldName.startsWith("ecm:")) {
            field = this.getSystemField(fieldName);
            if (field == null) {
                log.warn("Field: {} is not a valid field for aggregates", (Object)fieldName);
                return;
            }
        } else {
            field = this.schemaManager.getField(agg.getXPathField());
        }
        jg.writeObjectField("id", (Object)agg.getId());
        jg.writeObjectField("field", (Object)agg.getField());
        jg.writeObjectField("properties", (Object)agg.getProperties());
        jg.writeObjectField("ranges", (Object)agg.getRanges());
        jg.writeObjectField("selection", (Object)agg.getSelection());
        jg.writeObjectField("type", (Object)agg.getType());
        if (agg instanceof SingleValueMetricAggregate) {
            Double val = ((SingleValueMetricAggregate)agg).getValue();
            jg.writeObjectField("value", (Object)(Double.isFinite(val) ? val : null));
        } else if (agg instanceof SingleBucketAggregate) {
            jg.writeObjectField("value", (Object)((SingleBucketAggregate)agg).getDocCount());
        } else if (!fetch || !(agg instanceof TermAggregate) && !(agg instanceof SignificantTermAggregate)) {
            jg.writeObjectField("buckets", (Object)agg.getBuckets());
            jg.writeObjectField("extendedBuckets", (Object)agg.getExtendedBuckets());
        } else if (field != null) {
            try (Closeable resource = this.ctx.wrap().with("fetch.document", (Object)"properties").with("fetch.directoryEntry", (Object)"parent").with("translate.directoryEntry", (Object)"label").with("depth", (Object)"max").open();){
                Framework.doPrivilegedThrowing(() -> {
                    this.writeBuckets("buckets", agg.getBuckets(), field, jg);
                    this.writeBuckets("extendedBuckets", agg.getExtendedBuckets(), field, jg);
                });
            }
        } else {
            log.warn("Could not resolve field: {} for aggregate: {}", (Object)fieldName, (Object)agg.getId());
            jg.writeObjectField("buckets", (Object)agg.getBuckets());
            jg.writeObjectField("extendedBuckets", (Object)agg.getExtendedBuckets());
        }
    }

    protected void writeBuckets(String fieldName, List<Bucket> buckets, Field field, JsonGenerator jg) throws IOException {
        Schema schema = field.getDeclaringType().getSchema();
        DocumentPartImpl part = new DocumentPartImpl(schema);
        jg.writeArrayFieldStart(fieldName);
        for (Bucket bucket : buckets) {
            BucketRange bucketRange;
            jg.writeStartObject();
            jg.writeObjectField(FETCH_KEY, (Object)bucket.getKey());
            Property prop = PropertyFactory.createProperty((Property)part, (Field)field, (int)0);
            if (prop.isList()) {
                ListType t = (ListType)prop.getType();
                t.getField();
                prop = PropertyFactory.createProperty((Property)part, (Field)t.getField(), (int)0);
            }
            log.debug("Writing value: {} for field: {} resolved to: {}", (Object)fieldName, (Object)field.getName(), (Object)prop.getName());
            prop.setValue((Object)bucket.getKey());
            this.writeEntityField("fetchedKey", prop, jg);
            jg.writeNumberField("docCount", bucket.getDocCount());
            jg.writeEndObject();
            if (bucket instanceof BucketRange) {
                bucketRange = (BucketRange)bucket;
                jg.writeNumberField("from", bucketRange.getFrom().doubleValue());
                jg.writeNumberField("to", bucketRange.getTo().doubleValue());
            }
            if (!(bucket instanceof BucketRangeDate)) continue;
            bucketRange = (BucketRangeDate)bucket;
            jg.writeStringField("fromAsDate", DateUtils.formatISODateTime((ZonedDateTime)DateUtils.nowIfNull((ZonedDateTime)bucketRange.getFromAsDate())));
            jg.writeStringField("toAsDate", DateUtils.formatISODateTime((ZonedDateTime)DateUtils.nowIfNull((ZonedDateTime)bucketRange.getToAsDate())));
        }
        jg.writeEndArray();
    }

    static {
        SYSTEM_SCHEMA.addField("ecm:mixinType", (org.nuxeo.ecm.core.schema.types.Type)new ListTypeImpl("system", "", (org.nuxeo.ecm.core.schema.types.Type)StringType.INSTANCE), null, 0, null);
        SYSTEM_SCHEMA.addField("ecm:tag", (org.nuxeo.ecm.core.schema.types.Type)new ListTypeImpl("system", "", (org.nuxeo.ecm.core.schema.types.Type)StringType.INSTANCE), null, 0, null);
        SYSTEM_SCHEMA.addField("ecm:primaryType", (org.nuxeo.ecm.core.schema.types.Type)StringType.INSTANCE, null, 0, null);
        SYSTEM_SCHEMA.addField("ecm:currentLifeCycleState", (org.nuxeo.ecm.core.schema.types.Type)StringType.INSTANCE, null, 0, null);
        SYSTEM_SCHEMA.addField("ecm:versionLabel", (org.nuxeo.ecm.core.schema.types.Type)StringType.INSTANCE, null, 0, null);
        SYSTEM_SCHEMA.addField("ecm:isProxy", (org.nuxeo.ecm.core.schema.types.Type)BooleanType.INSTANCE, null, 0, null);
        SYSTEM_SCHEMA.addField("ecm:isRecord", (org.nuxeo.ecm.core.schema.types.Type)BooleanType.INSTANCE, null, 0, null);
        SYSTEM_SCHEMA.addField("ecm:retainUntil", (org.nuxeo.ecm.core.schema.types.Type)DateType.INSTANCE, null, 0, null);
        SYSTEM_SCHEMA.addField("ecm:hasLegalHold", (org.nuxeo.ecm.core.schema.types.Type)BooleanType.INSTANCE, null, 0, null);
        SYSTEM_SCHEMA.addField("ecm:isTrashed", (org.nuxeo.ecm.core.schema.types.Type)BooleanType.INSTANCE, null, 0, null);
    }
}

