/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Synchronization;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.directory.AbstractDirectory;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.sql.SQLDirectoryDescriptor;
import org.nuxeo.ecm.directory.sql.SQLHelper;
import org.nuxeo.ecm.directory.sql.SQLSession;
import org.nuxeo.ecm.directory.sql.TableReference;
import org.nuxeo.ecm.directory.sql.TableReferenceDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.datasource.ConnectionHelper;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class SQLDirectory
extends AbstractDirectory {
    public static final Log log = LogFactory.getLog(SQLDirectory.class);
    private final boolean nativeCase;
    private Table table;
    private Schema schema;
    protected List<Column> readColumnsAll;
    protected List<Column> readColumns;
    protected Column idColumn;
    protected String readColumnsAllSQL;
    protected String readColumnsSQL;
    private volatile Dialect dialect;

    public SQLDirectory(SQLDirectoryDescriptor descriptor) {
        super((BaseDirectoryDescriptor)descriptor, TableReference.class);
        this.nativeCase = Boolean.TRUE.equals(descriptor.nativeCase);
        this.fallbackOnDefaultCache();
    }

    public SQLDirectoryDescriptor getDescriptor() {
        return (SQLDirectoryDescriptor)this.descriptor;
    }

    protected void addReferences() {
        super.addReferences();
        TableReferenceDescriptor[] descs = this.getDescriptor().getTableReferences();
        if (descs != null) {
            Arrays.stream(descs).map(TableReference::new).forEach(arg_0 -> ((SQLDirectory)this).addReference(arg_0));
        }
    }

    public void initialize() {
        super.initialize();
        SQLDirectoryDescriptor descriptor = this.getDescriptor();
        try (Connection sqlConnection = this.getConnection();){
            boolean tableExists;
            this.dialect = Dialect.createDialect((Connection)sqlConnection, null);
            String tableName = descriptor.tableName == null ? descriptor.name : descriptor.tableName;
            this.table = SQLHelper.addTable(tableName, this.dialect, this.useNativeCase());
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            this.schema = schemaManager.getSchema(this.getSchema());
            if (this.schema == null) {
                throw new DirectoryException("schema not found: " + this.getSchema());
            }
            this.readColumnsAll = new LinkedList<Column>();
            this.readColumns = new LinkedList<Column>();
            boolean hasPrimary = false;
            for (Field f : this.schema.getFields()) {
                String fieldName = f.getName().getLocalName();
                if (this.isReference(fieldName)) continue;
                boolean isId = fieldName.equals(this.getIdField());
                ColumnType type = ColumnType.fromField((Field)f);
                if (isId && descriptor.isAutoincrementIdField()) {
                    type = ColumnType.AUTOINC;
                }
                Column column = SQLHelper.addColumn(this.table, fieldName, type, this.useNativeCase());
                if (isId) {
                    if (descriptor.isAutoincrementIdField()) {
                        column.setIdentity(true);
                    }
                    column.setPrimary(true);
                    column.setNullable(false);
                    this.idColumn = column;
                    hasPrimary = true;
                }
                this.readColumnsAll.add(column);
                if (fieldName.equals(descriptor.passwordField)) continue;
                this.readColumns.add(column);
            }
            this.readColumnsAllSQL = this.readColumnsAll.stream().map(Column::getQuotedName).collect(Collectors.joining(", "));
            this.readColumnsSQL = this.readColumns.stream().map(Column::getQuotedName).collect(Collectors.joining(", "));
            if (!hasPrimary) {
                throw new DirectoryException(String.format("Directory '%s' id field '%s' is not present in schema '%s'", this.getName(), this.getIdField(), this.getSchema()));
            }
            SQLHelper helper = new SQLHelper(sqlConnection, this.table, descriptor.getCreateTablePolicy());
            boolean bl = tableExists = !helper.setupTable();
            if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
            this.loadDataOnInit(tableExists);
        }
        catch (SQLException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public void initializeReferences() {
        try (Connection connection = this.getConnection();){
            for (Reference reference : this.getReferences()) {
                if (!(reference instanceof TableReference)) continue;
                ((TableReference)reference).initialize(connection);
            }
        }
        catch (SQLException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public Connection getConnection() {
        SQLDirectoryDescriptor descriptor = this.getDescriptor();
        if (StringUtils.isBlank((CharSequence)descriptor.dataSourceName)) {
            throw new DirectoryException("Missing dataSource for SQL directory: " + this.getName());
        }
        try {
            return ConnectionHelper.getConnection((String)descriptor.dataSourceName);
        }
        catch (SQLException e) {
            throw new DirectoryException("Cannot connect to SQL directory '" + this.getName() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    public SQLSession getSession() {
        SQLSession session = new SQLSession(this, this.getDescriptor());
        this.addSession(session);
        return session;
    }

    protected void addSession(SQLSession session) {
        super.addSession((Session)session);
        this.registerInTx(session);
    }

    protected void registerInTx(SQLSession session) {
        if (!TransactionHelper.isTransactionActive()) {
            return;
        }
        TransactionHelper.registerSynchronization((Synchronization)new TxSessionCleaner(session));
    }

    public Table getTable() {
        return this.table;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public boolean useNativeCase() {
        return this.nativeCase;
    }

    public boolean isMultiTenant() {
        return this.table.getColumn("tenantId") != null;
    }

    public String toString() {
        return "SQLDirectory [name=" + this.descriptor.name + "]";
    }

    protected class TxSessionCleaner
    implements Synchronization {
        private final SQLSession session;
        Throwable initContext = this.captureInitContext();

        protected TxSessionCleaner(SQLSession session) {
            this.session = session;
        }

        protected Throwable captureInitContext() {
            if (!log.isDebugEnabled()) {
                return null;
            }
            return new Throwable("SQL directory session init context in " + SQLDirectory.this);
        }

        protected void checkIsNotLive() {
            try {
                if (!this.session.isLive()) {
                    return;
                }
                if (this.initContext != null) {
                    log.warn((Object)("Closing a sql directory session for you " + this.session), this.initContext);
                } else {
                    log.warn((Object)("Closing a sql directory session for you " + this.session));
                }
                if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                    log.warn((Object)("Closing sql directory session outside a transaction" + this.session));
                }
                this.session.close();
            }
            catch (DirectoryException e) {
                log.error((Object)("Cannot state on sql directory session before commit " + SQLDirectory.this), (Throwable)e);
            }
        }

        public void beforeCompletion() {
            this.checkIsNotLive();
        }

        public void afterCompletion(int status) {
            this.checkIsNotLive();
        }
    }
}

