/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.tomcat.dev;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import org.nuxeo.runtime.tomcat.dev.DevBundleType;

public class DevBundle
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected final DevBundleType devBundleType;
    protected final String path;

    public static DevBundle[] parseDevBundleLines(InputStream is) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line;
            ArrayList<DevBundle> bundles = new ArrayList<DevBundle>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                bundles.add(DevBundle.parseDevBundleLine(line));
            }
            DevBundle[] devBundleArray = bundles.toArray(new DevBundle[bundles.size()]);
            return devBundleArray;
        }
    }

    public static DevBundle parseDevBundleLine(String line) {
        int index = line.indexOf(58);
        Object typename = line.substring(0, index);
        typename = ((String)typename).substring(0, 1).toUpperCase() + ((String)typename).substring(1);
        String path = line.substring(index + 1);
        return new DevBundle(path, DevBundleType.valueOf((String)typename));
    }

    public DevBundle(String path, DevBundleType devBundleType) {
        this.path = path;
        this.devBundleType = devBundleType;
    }

    public URL url() throws IOException {
        return this.file().toURI().toURL();
    }

    public File file() {
        return new File(this.path);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.file().getAbsolutePath();
    }

    public DevBundleType getDevBundleType() {
        return this.devBundleType;
    }

    public String toString() {
        return this.devBundleType.toString().toLowerCase() + ":" + this.path;
    }
}

