/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetType;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.converters.LayoutDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.converters.WidgetDefinitionConverter;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetTypeImpl;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.forms.layout.core.registries.AbstractCategoryMapRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.LayoutConverterRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.LayoutDefinitionRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.LayoutTypeDefinitionRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.WidgetConverterRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.WidgetDefinitionRegistry;
import org.nuxeo.ecm.platform.forms.layout.core.registries.WidgetTypeDefinitionRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class LayoutStoreImpl
extends DefaultComponent
implements LayoutStore {
    private static final Logger log = LogManager.getLogger(LayoutStoreImpl.class);
    public static final String WIDGET_TYPES_EP_NAME = "widgettypes";
    public static final String LAYOUT_TYPES_EP_NAME = "layouttypes";
    public static final String WIDGETS_EP_NAME = "widgets";
    public static final String LAYOUTS_EP_NAME = "layouts";
    public static final String LAYOUT_CONVERTERS_EP_NAME = "layoutConverters";
    public static final String WIDGET_CONVERTERS_EP_NAME = "widgetConverters";
    protected Map<String, Map<String, WidgetType>> widgetTypesByCat;
    protected Map<String, List<WidgetDefinitionConverter>> widgetConvertersByCat;
    protected Map<String, List<LayoutDefinitionConverter>> layoutConvertersByCat;

    public void start(ComponentContext context) {
        this.initWidgetTypes();
        this.initWidgetConverters();
        this.initLayoutConverters();
    }

    protected void initWidgetTypes() {
        this.widgetTypesByCat = new HashMap<String, Map<String, WidgetType>>();
        WidgetTypeDefinitionRegistry widgetTypeReg = (WidgetTypeDefinitionRegistry)this.getExtensionPointRegistry(WIDGET_TYPES_EP_NAME);
        widgetTypeReg.getCategories().forEach(cat -> {
            List<WidgetTypeDefinition> descs = widgetTypeReg.getContributionValues((String)cat);
            descs.forEach(desc -> {
                String className = desc.getHandlerClassName();
                Class<?> widgetTypeClass = null;
                if (className != null) {
                    try {
                        widgetTypeClass = LayoutStoreImpl.class.getClassLoader().loadClass(className);
                    }
                    catch (ReflectiveOperationException e) {
                        log.error("Caught error when instantiating widget type handler", (Throwable)e);
                        return;
                    }
                }
                String name = desc.getName();
                WidgetTypeImpl widgetType = new WidgetTypeImpl(name, widgetTypeClass, desc.getProperties());
                List aliases = desc.getAliases();
                widgetType.setAliases(aliases);
                this.widgetTypesByCat.computeIfAbsent((String)cat, k -> new HashMap()).put(name, widgetType);
                aliases.forEach(alias -> this.widgetTypesByCat.get(cat).put((String)alias, (WidgetType)widgetType));
            });
        });
    }

    protected void initWidgetConverters() {
        this.widgetConvertersByCat = new HashMap<String, List<WidgetDefinitionConverter>>();
        WidgetConverterRegistry reg = (WidgetConverterRegistry)this.getExtensionPointRegistry(WIDGET_CONVERTERS_EP_NAME);
        reg.getCategories().forEach(cat -> {
            List descs = reg.getContributionValues((String)cat);
            ArrayList converters = new ArrayList();
            ArrayList names = new ArrayList();
            descs.stream().sorted().forEach(desc -> {
                String name = desc.getName();
                try {
                    Class<?> converterClass = LayoutStoreImpl.class.getClassLoader().loadClass(desc.getConverterClassName());
                    converters.add((WidgetDefinitionConverter)converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    names.add(name);
                }
                catch (ClassCastException | ReflectiveOperationException e) {
                    log.error("Caught error when instantiating widget definition converter {}", (Object)name, (Object)e);
                    return;
                }
            });
            log.debug("Ordered widget converters for category '{}': {}", cat, names);
            this.widgetConvertersByCat.put((String)cat, converters);
        });
    }

    protected void initLayoutConverters() {
        this.layoutConvertersByCat = new HashMap<String, List<LayoutDefinitionConverter>>();
        LayoutConverterRegistry reg = (LayoutConverterRegistry)this.getExtensionPointRegistry(LAYOUT_CONVERTERS_EP_NAME);
        reg.getCategories().forEach(cat -> {
            List descs = reg.getContributionValues((String)cat);
            ArrayList converters = new ArrayList();
            ArrayList names = new ArrayList();
            descs.stream().sorted().forEach(desc -> {
                String name = desc.getName();
                try {
                    Class<?> converterClass = LayoutStoreImpl.class.getClassLoader().loadClass(desc.getConverterClassName());
                    converters.add((LayoutDefinitionConverter)converterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    names.add(name);
                }
                catch (ClassCastException | ReflectiveOperationException e) {
                    log.error("Caught error when instantiating layout definition converter {}", (Object)name, (Object)e);
                    return;
                }
            });
            log.debug("Ordered layout converters for category '{}': {}", cat, names);
            this.layoutConvertersByCat.put((String)cat, converters);
        });
    }

    public void stop(ComponentContext context) throws InterruptedException {
        this.widgetTypesByCat = null;
        this.widgetConvertersByCat = null;
        this.layoutConvertersByCat = null;
    }

    public List<String> getCategories() {
        return Stream.of((AbstractCategoryMapRegistry)this.getExtensionPointRegistry(WIDGET_TYPES_EP_NAME), (AbstractCategoryMapRegistry)this.getExtensionPointRegistry(LAYOUTS_EP_NAME), (AbstractCategoryMapRegistry)this.getExtensionPointRegistry(WIDGETS_EP_NAME)).map(AbstractCategoryMapRegistry::getCategories).flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList());
    }

    public WidgetType getWidgetType(String category, String typeName) {
        return (WidgetType)this.widgetTypesByCat.getOrDefault(category, Collections.emptyMap()).get(typeName);
    }

    public WidgetTypeDefinition getWidgetTypeDefinition(String category, String typeName) {
        WidgetTypeDefinitionRegistry widgetTypeReg = (WidgetTypeDefinitionRegistry)this.getExtensionPointRegistry(WIDGET_TYPES_EP_NAME);
        return (WidgetTypeDefinition)widgetTypeReg.getContribution(category, typeName);
    }

    public List<WidgetTypeDefinition> getWidgetTypeDefinitions(String category) {
        WidgetTypeDefinitionRegistry widgetTypeReg = (WidgetTypeDefinitionRegistry)this.getExtensionPointRegistry(WIDGET_TYPES_EP_NAME);
        return widgetTypeReg.getContributionValues(category);
    }

    public LayoutTypeDefinition getLayoutTypeDefinition(String category, String typeName) {
        LayoutTypeDefinitionRegistry reg = (LayoutTypeDefinitionRegistry)this.getExtensionPointRegistry(LAYOUT_TYPES_EP_NAME);
        return (LayoutTypeDefinition)reg.getContribution(category, typeName);
    }

    public List<LayoutTypeDefinition> getLayoutTypeDefinitions(String category) {
        LayoutTypeDefinitionRegistry reg = (LayoutTypeDefinitionRegistry)this.getExtensionPointRegistry(LAYOUT_TYPES_EP_NAME);
        return reg.getContributionValues(category);
    }

    public LayoutDefinition getLayoutDefinition(String category, String layoutName) {
        LayoutDefinitionRegistry reg = (LayoutDefinitionRegistry)this.getExtensionPointRegistry(LAYOUTS_EP_NAME);
        return (LayoutDefinition)reg.getContribution(category, layoutName);
    }

    public List<String> getLayoutDefinitionNames(String category) {
        LayoutDefinitionRegistry reg = (LayoutDefinitionRegistry)this.getExtensionPointRegistry(LAYOUTS_EP_NAME);
        return new ArrayList<String>(reg.getContributions(category).keySet());
    }

    public WidgetDefinition getWidgetDefinition(String category, String widgetName) {
        WidgetDefinitionRegistry reg = (WidgetDefinitionRegistry)this.getExtensionPointRegistry(WIDGETS_EP_NAME);
        return (WidgetDefinition)reg.getContribution(category, widgetName);
    }

    public List<LayoutDefinitionConverter> getLayoutConverters(String category) {
        return Collections.unmodifiableList(this.layoutConvertersByCat.getOrDefault(category, Collections.emptyList()));
    }

    public List<WidgetDefinitionConverter> getWidgetConverters(String category) {
        return Collections.unmodifiableList(this.widgetConvertersByCat.getOrDefault(category, Collections.emptyList()));
    }
}

