/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.descriptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.common.xmap.registry.XRegistry;
import org.nuxeo.common.xmap.registry.XRegistryId;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutTypeDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.descriptors.LayoutTypeConfigurationDescriptor;

@XObject(value="layoutType")
@XRegistry(merge=false)
public class LayoutTypeDescriptor {
    @XNode(value="@name")
    @XRegistryId
    String name;
    @XNodeList(value="aliases/alias", type=ArrayList.class, componentType=String.class)
    List<String> aliases;
    @XNodeMap(value="templates/template", key="@mode", type=HashMap.class, componentType=String.class)
    Map<String, String> templates = new HashMap<String, String>();
    @XNode(value="configuration")
    LayoutTypeConfigurationDescriptor configuration;
    @XNode(value="@category")
    protected String category;
    @XNodeList(value="categories/category", type=String[].class, componentType=String.class)
    String[] categories = new String[0];

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public Map<String, String> getTemplates() {
        return this.templates;
    }

    public LayoutTypeConfiguration getConfiguration() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getLayoutTypeConfiguration();
    }

    public String[] getCategories() {
        HashSet<String> cats = new HashSet<String>();
        if (this.category != null) {
            cats.add(this.category);
        }
        cats.addAll(Arrays.asList(this.categories));
        return (String[])cats.toArray(String[]::new);
    }

    public LayoutTypeDefinition getLayoutTypeDefinition() {
        LayoutTypeDefinitionImpl res = new LayoutTypeDefinitionImpl(this.name, this.templates, this.getConfiguration());
        res.setAliases(this.getAliases());
        return res;
    }
}

