/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import java.util.function.Supplier;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.support.wrapper.ConformanceCmisServiceWrapper;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.RecoverableClientException;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuxeoCmisServiceWrapper
extends ConformanceCmisServiceWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(NuxeoCmisServiceWrapper.class);

    public NuxeoCmisServiceWrapper(CmisService service) {
        super(service);
    }

    protected CmisBaseException createCmisException(Exception e) {
        TransactionHelper.setTransactionRollbackOnly();
        if (e == null) {
            return new CmisRuntimeException("Unknown exception!");
        }
        if (e instanceof CmisBaseException) {
            return (CmisBaseException)e;
        }
        if (e instanceof RecoverableClientException) {
            return new CmisRuntimeException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof QueryParseException) {
            return new CmisInvalidArgumentException(e.getMessage(), (Throwable)e);
        }
        if (e instanceof ConcurrentUpdateException) {
            return new CmisUpdateConflictException(e.getMessage(), (Throwable)e);
        }
        LOG.warn(e.toString(), (Throwable)e);
        return new CmisRuntimeException(e.getMessage(), (Throwable)e);
    }

    protected void runWithRetryOnConflict(Runnable runnable) {
        this.runWithRetryOnConflict(() -> {
            runnable.run();
            return null;
        });
    }

    protected <R> R runWithRetryOnConflict(Supplier<R> supplier) {
        try {
            return supplier.get();
        }
        catch (CmisUpdateConflictException e) {
            TransactionHelper.setTransactionRollbackOnly();
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
            return supplier.get();
        }
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.runWithRetryOnConflict(() -> super.deleteObject(repositoryId, objectId, allVersions, extension));
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        this.runWithRetryOnConflict(() -> super.deleteObjectOrCancelCheckOut(repositoryId, objectId, allVersions, extension));
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        return this.runWithRetryOnConflict(() -> super.deleteTree(repositoryId, folderId, allVersions, unfileObjects, continueOnFailure, extension));
    }
}

