/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.plugins;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.cache.SimpleCachableBlobHolder;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineBasedConverter;

public class PDF2ImageConverter
extends CommandLineBasedConverter {
    protected BlobHolder buildResult(List<String> cmdOutput, CmdParameters cmdParams) {
        String outputPath = cmdParams.getParameter("outDirPath");
        File outputDir = new File(outputPath);
        File[] files = outputDir.listFiles();
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (File file : files) {
            try {
                Blob blob = Blobs.createBlob((File)file);
                blob.setFilename(file.getName());
                blobs.add(blob);
            }
            catch (IOException e) {
                throw new ConversionException("Cannot create Blob", (Throwable)e);
            }
        }
        return new SimpleCachableBlobHolder(blobs);
    }

    protected Map<String, Blob> getCmdBlobParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        HashMap<String, Blob> cmdBlobParams = new HashMap<String, Blob>();
        cmdBlobParams.put("inputFilePath", blobHolder.getBlob());
        return cmdBlobParams;
    }

    protected Map<String, String> getCmdStringParameters(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        HashMap<String, String> cmdStringParams = new HashMap<String, String>();
        String baseDir = this.getTmpDirectory(parameters);
        Path tmpPath = new Path(baseDir).append("pdf2image_" + System.currentTimeMillis());
        File outDir = new File(tmpPath.toString());
        boolean dirCreated = outDir.mkdir();
        if (!dirCreated) {
            throw new ConversionException("Unable to create tmp dir for transformer output", blobHolder);
        }
        cmdStringParams.put("outDirPath", outDir.getAbsolutePath());
        cmdStringParams.put("outputFilePath", outDir.getAbsolutePath() + System.getProperty("file.separator") + parameters.get("targetFilePath").toString());
        return cmdStringParams;
    }
}

